/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.bizkeeper;

import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.bizkeeper.BizkeeperExceptionUtils;
import org.apache.servicecomb.bizkeeper.Configuration;
import org.apache.servicecomb.bizkeeper.FallbackPolicy;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.swagger.invocation.InvocationType;
import org.apache.servicecomb.swagger.invocation.Response;

public class FallbackPolicyManager {
    private static final Map<String, FallbackPolicy> POLICIES = new HashMap<String, FallbackPolicy>();

    public static void addPolicy(FallbackPolicy policy) {
        POLICIES.put(policy.name().toLowerCase(), policy);
    }

    public static void record(String type, Invocation invocation, Response response, boolean isSuccess) {
        FallbackPolicy policy = FallbackPolicyManager.getPolicy(type, invocation);
        if (policy != null) {
            policy.record(invocation, response, isSuccess);
        }
    }

    public static Response getFallbackResponse(String type, Throwable error, Invocation invocation) {
        FallbackPolicy policy = FallbackPolicyManager.getPolicy(type, invocation);
        if (policy != null) {
            return policy.getFallbackResponse(invocation, error);
        }
        return Response.failResp((InvocationType)invocation.getInvocationType(), (Throwable)BizkeeperExceptionUtils.createBizkeeperException("servicecomb.bizkeeper.fallback", error, invocation.getOperationMeta().getMicroserviceQualifiedName()));
    }

    private static FallbackPolicy getPolicy(String type, Invocation invocation) {
        String policyKey = Configuration.INSTANCE.getFallbackPolicyPolicy(type, invocation.getMicroserviceName(), invocation.getOperationMeta().getMicroserviceQualifiedName());
        FallbackPolicy policy = null;
        if (policyKey != null) {
            policy = POLICIES.get(policyKey.toLowerCase());
        }
        return policy;
    }
}

