/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core.processor.parameter;

import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.Parameter;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.swagger.generator.core.OperationGenerator;
import org.apache.servicecomb.swagger.generator.core.ParameterAnnotationProcessor;
import org.apache.servicecomb.swagger.generator.core.utils.ParamUtils;

public abstract class AbstractParameterProcessor<T extends AbstractSerializableParameter<?>>
implements ParameterAnnotationProcessor {
    @Override
    public void process(Object annotation, OperationGenerator operationGenerator, int paramIdx) {
        T parameter = this.createParameter();
        this.fillParameter(annotation, operationGenerator, paramIdx, parameter);
        operationGenerator.addProviderParameter((Parameter)parameter);
    }

    protected void fillParameter(Object annotation, OperationGenerator operationGenerator, int paramIdx, T parameter) {
        this.setParameterName(annotation, operationGenerator, paramIdx, parameter);
        this.setParameterType(operationGenerator, paramIdx, parameter);
        this.setParameterDefaultValue(annotation, parameter);
    }

    protected void setParameterType(OperationGenerator operationGenerator, int paramIdx, T parameter) {
        ParamUtils.setParameterType(operationGenerator.getSwagger(), operationGenerator.getProviderMethod(), paramIdx, parameter);
    }

    protected void setParameterName(Object annotation, OperationGenerator operationGenerator, int paramIdx, T parameter) {
        String paramName = this.getAnnotationParameterName(annotation);
        paramName = ParamUtils.getParameterName(paramName, operationGenerator.getProviderMethod(), paramIdx);
        parameter.setName(paramName);
    }

    protected void setParameterDefaultValue(Object annotation, T parameter) {
        String defaultValue = this.getAnnotationParameterDefaultValue(annotation);
        if (StringUtils.isNotEmpty((CharSequence)defaultValue)) {
            parameter.setDefaultValue(defaultValue);
        }
    }

    protected String getAnnotationParameterDefaultValue(Object annotation) {
        return "";
    }

    public abstract T createParameter();

    public abstract String getAnnotationParameterName(Object var1);
}

