/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.servlet;

import javax.servlet.MultipartConfigElement;
import org.springframework.util.unit.DataSize;

public class MultipartConfigFactory {
    private String location;
    private DataSize maxFileSize;
    private DataSize maxRequestSize;
    private DataSize fileSizeThreshold;

    public void setLocation(String location) {
        this.location = location;
    }

    public void setMaxFileSize(DataSize maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    @Deprecated
    public void setMaxFileSize(long maxFileSize) {
        this.setMaxFileSize(DataSize.ofBytes((long)maxFileSize));
    }

    @Deprecated
    public void setMaxFileSize(String maxFileSize) {
        this.setMaxFileSize(DataSize.parse((CharSequence)maxFileSize));
    }

    public void setMaxRequestSize(DataSize maxRequestSize) {
        this.maxRequestSize = maxRequestSize;
    }

    @Deprecated
    public void setMaxRequestSize(long maxRequestSize) {
        this.setMaxRequestSize(DataSize.ofBytes((long)maxRequestSize));
    }

    @Deprecated
    public void setMaxRequestSize(String maxRequestSize) {
        this.setMaxRequestSize(DataSize.parse((CharSequence)maxRequestSize));
    }

    public void setFileSizeThreshold(DataSize fileSizeThreshold) {
        this.fileSizeThreshold = fileSizeThreshold;
    }

    @Deprecated
    public void setFileSizeThreshold(int fileSizeThreshold) {
        this.setFileSizeThreshold(DataSize.ofBytes((long)fileSizeThreshold));
    }

    @Deprecated
    public void setFileSizeThreshold(String fileSizeThreshold) {
        this.setFileSizeThreshold(DataSize.parse((CharSequence)fileSizeThreshold));
    }

    public MultipartConfigElement createMultipartConfig() {
        long maxFileSizeBytes = this.convertToBytes(this.maxFileSize, -1);
        long maxRequestSizeBytes = this.convertToBytes(this.maxRequestSize, -1);
        long fileSizeThresholdBytes = this.convertToBytes(this.fileSizeThreshold, 0);
        return new MultipartConfigElement(this.location, maxFileSizeBytes, maxRequestSizeBytes, (int)fileSizeThresholdBytes);
    }

    private long convertToBytes(DataSize size, int defaultValue) {
        if (size != null && !size.isNegative()) {
            return size.toBytes();
        }
        return defaultValue;
    }
}

