/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class OasSpecLoader {
    protected abstract SwaggerParseResult parseAbsolute(String var1);

    protected final OpenAPI loadAbsolute(String classpath) {
        SwaggerParseResult parseResult = this.parseAbsolute(classpath);
        if (CollectionUtils.isNotEmpty((Collection)parseResult.getMessages())) {
            throw new RuntimeException(StringUtils.join((Iterable)parseResult.getMessages(), (String)","));
        }
        return parseResult.getOpenAPI();
    }

    protected final OpenAPI loadRelative(String fileName) {
        String basePath = this.getClass().getPackage().getName().replaceAll("\\.", "/");
        return this.loadAbsolute(basePath + "/" + fileName);
    }
}

