/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.io.File;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.CppQt5AbstractCodegen;
import org.openapitools.codegen.utils.StringUtils;

public class CppQt5ClientCodegen
extends CppQt5AbstractCodegen
implements CodegenConfig {
    public static final String OPTIONAL_PROJECT_FILE_DESC = "Generate client.pri.";
    protected String sourceFolder = "client";
    protected boolean optionalProjectFileFlag = true;

    public CppQt5ClientCodegen() {
        this.outputFolder = "generated-code/qt5cpp";
        this.modelTemplateFiles.put("model-header.mustache", ".h");
        this.modelTemplateFiles.put("model-body.mustache", ".cpp");
        this.apiTemplateFiles.put("api-header.mustache", ".h");
        this.apiTemplateFiles.put("api-body.mustache", ".cpp");
        this.templateDir = "cpp-qt5-client";
        this.embeddedTemplateDir = "cpp-qt5-client";
        this.addSwitch("optionalProjectFile", OPTIONAL_PROJECT_FILE_DESC, this.optionalProjectFileFlag);
        this.supportingFiles.add(new SupportingFile("helpers-header.mustache", this.sourceFolder, "OAIHelpers.h"));
        this.supportingFiles.add(new SupportingFile("helpers-body.mustache", this.sourceFolder, "OAIHelpers.cpp"));
        this.supportingFiles.add(new SupportingFile("HttpRequest.h.mustache", this.sourceFolder, "OAIHttpRequest.h"));
        this.supportingFiles.add(new SupportingFile("HttpRequest.cpp.mustache", this.sourceFolder, "OAIHttpRequest.cpp"));
        this.supportingFiles.add(new SupportingFile("object.mustache", this.sourceFolder, "OAIObject.h"));
        this.supportingFiles.add(new SupportingFile("enum.mustache", this.sourceFolder, "OAIEnum.h"));
        if (this.optionalProjectFileFlag) {
            this.supportingFiles.add(new SupportingFile("Project.mustache", this.sourceFolder, "client.pri"));
        }
        this.typeMapping.put("file", "OAIHttpRequestInputFileElement");
        this.typeMapping.put("binary", "OAIHttpRequestInputFileElement");
        this.importMapping.put("OAIHttpRequestInputFileElement", "#include \"OAIHttpRequest.h\"");
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("optionalProjectFile")) {
            this.setOptionalProjectFileFlag(this.convertPropertyToBooleanAndWriteBack("optionalProjectFile"));
        } else {
            this.additionalProperties.put("optionalProjectFile", this.optionalProjectFileFlag);
        }
        if (this.additionalProperties.containsKey("modelNamePrefix")) {
            this.supportingFiles.clear();
            this.supportingFiles.add(new SupportingFile("helpers-header.mustache", this.sourceFolder, this.modelNamePrefix + "Helpers.h"));
            this.supportingFiles.add(new SupportingFile("helpers-body.mustache", this.sourceFolder, this.modelNamePrefix + "Helpers.cpp"));
            this.supportingFiles.add(new SupportingFile("HttpRequest.h.mustache", this.sourceFolder, this.modelNamePrefix + "HttpRequest.h"));
            this.supportingFiles.add(new SupportingFile("HttpRequest.cpp.mustache", this.sourceFolder, this.modelNamePrefix + "HttpRequest.cpp"));
            this.supportingFiles.add(new SupportingFile("object.mustache", this.sourceFolder, this.modelNamePrefix + "Object.h"));
            this.supportingFiles.add(new SupportingFile("enum.mustache", this.sourceFolder, this.modelNamePrefix + "Enum.h"));
            this.typeMapping.put("file", this.modelNamePrefix + "HttpRequestInputFileElement");
            this.typeMapping.put("binary", this.modelNamePrefix + "HttpRequestInputFileElement");
            this.importMapping.put(this.modelNamePrefix + "HttpRequestInputFileElement", "#include \"" + this.modelNamePrefix + "HttpRequest.h\"");
            if (this.optionalProjectFileFlag) {
                this.supportingFiles.add(new SupportingFile("Project.mustache", this.sourceFolder, this.modelNamePrefix + "client.pri"));
            }
        }
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "cpp-qt5-client";
    }

    @Override
    public String getHelp() {
        return "Generates a Qt5 C++ client library.";
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.modelPackage().replace("::", File.separator);
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.apiPackage().replace("::", File.separator);
    }

    @Override
    public String toApiFilename(String name) {
        return this.modelNamePrefix + this.sanitizeName(StringUtils.camelize(name)) + "Api";
    }

    public void setOptionalProjectFileFlag(boolean flag) {
        this.optionalProjectFileFlag = flag;
    }
}

