/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.config;

import com.netflix.config.DynamicPropertyFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.servicecomb.serviceregistry.api.registry.BasePath;

public final class ConfigurePropertyUtils {
    private ConfigurePropertyUtils() {
    }

    public static Map<String, String> getPropertiesWithPrefix(String prefix) {
        Object config = DynamicPropertyFactory.getBackingConfigurationSource();
        if (!Configuration.class.isInstance(config)) {
            return new HashMap<String, String>();
        }
        return ConfigurePropertyUtils.getPropertiesWithPrefix((Configuration)config, prefix);
    }

    public static Map<String, String> getPropertiesWithPrefix(Configuration configuration, String prefix) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        Iterator keysIterator = configuration.getKeys(prefix);
        while (keysIterator.hasNext()) {
            String key = (String)keysIterator.next();
            propertiesMap.put(key.substring(prefix.length() + 1), String.valueOf(configuration.getProperty(key)));
        }
        return propertiesMap;
    }

    public static List<BasePath> getMicroservicePaths(Configuration configuration) {
        ArrayList<BasePath> basePaths = new ArrayList<BasePath>();
        for (Object path : configuration.getList("service_description.paths")) {
            BasePath basePath = new BasePath();
            Map pathMap = (Map)path;
            basePath.setPath(ConfigurePropertyUtils.buildPath((String)pathMap.get("path")));
            basePath.setProperty((Map)pathMap.get("property"));
            basePaths.add(basePath);
        }
        return basePaths;
    }

    private static String buildPath(String path) {
        String prefix = System.getProperty("urlPrefix");
        if (StringUtils.isNotEmpty((String)prefix) && !path.startsWith(prefix)) {
            path = prefix + path;
        }
        return path;
    }
}

