/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.codegen;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.servicecomb.toolkit.codegen.AbstractJavaCodegenExt;
import org.apache.servicecomb.toolkit.codegen.GetGenericClassTypeLambda;
import org.apache.servicecomb.toolkit.codegen.GetRelativeBasePathLambda;
import org.apache.servicecomb.toolkit.codegen.ServiceType;
import org.apache.servicecomb.toolkit.codegen.ShowBasePathLambda;
import org.apache.servicecomb.toolkit.codegen.SpringCloudConsumerDirectoryStrategy;
import org.apache.servicecomb.toolkit.codegen.SpringCloudMultiDirectoryStrategy;
import org.apache.servicecomb.toolkit.codegen.SpringCloudProviderDirectoryStrategy;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.templating.mustache.CamelCaseLambda;
import org.openapitools.codegen.utils.StringUtils;

public class SpringCloudCodegen
extends AbstractJavaCodegenExt {
    private String applicationId = "defaultApp";
    private String serviceId = "defaultService";
    private String consumerTemplateFolder = "consumer/openfeign";
    private String providerTemplateFolder = "provider/servlet";
    private String modelTemplateFolder = "model";
    private String apiConsumerTemplate = this.consumerTemplateFolder + "/apiConsumer.mustache";

    public SpringCloudCodegen() {
        this.outputFolder = "generated-code/SpringCloud";
        this.apiTemplateFiles.remove("api.mustache");
        this.apiTemplateFiles.put(this.providerTemplateFolder + "/api.mustache", ".java");
        this.templateDir = "SpringCloud";
        this.embeddedTemplateDir = "SpringCloud";
        this.modelTemplateFiles.put(this.modelTemplateFolder + "/model.mustache", ".java");
        this.modelTemplateFiles.remove("model.mustache");
        this.addDirectoryStrategy(new SpringCloudProviderDirectoryStrategy(), ServiceType.PROVIDER.getValue());
        this.addDirectoryStrategy(new SpringCloudConsumerDirectoryStrategy(), ServiceType.CONSUMER.getValue());
        this.addDirectoryStrategy(new SpringCloudMultiDirectoryStrategy(), ServiceType.ALL.getValue());
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.importMapping.put("OffsetDateTime", "java.time.OffsetDateTime");
        this.additionalProperties.put("dateLibrary", "java8");
        this.additionalProperties.put("camelcase", new CamelCaseLambda());
        this.additionalProperties.put("apiTemplateFiles", this.apiTemplateFiles);
        this.additionalProperties.put("getGenericClassType", new GetGenericClassTypeLambda());
        this.additionalProperties.put("getRelativeBasePath", new GetRelativeBasePathLambda());
        this.additionalProperties.put("showBasePath", new ShowBasePathLambda());
        this.additionalProperties.put("applicationId", this.applicationId);
        if (this.additionalProperties.get("serviceId") != null) {
            this.serviceId = (String)this.additionalProperties.get("serviceId");
        }
        this.additionalProperties.put("serviceId", this.serviceId);
        this.currentDirectoryStrategy = this.getStrategyMap().get(Optional.ofNullable(this.additionalProperties.get("serviceType")).orElse(ServiceType.ALL.getValue()));
        this.currentDirectoryStrategy.addCustomProperties(this.additionalProperties);
        this.currentDirectoryStrategy.processSupportingFile(this.supportingFiles);
    }

    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        String apiName = (String)this.additionalProperties.get("apiName");
        if (apiName != null) {
            return apiName;
        }
        return StringUtils.camelize((String)name) + "Api";
    }

    public String apiFileFolder() {
        return this.outputFolder + "/" + this.currentDirectoryStrategy.providerDirectory() + "/" + this.sourceFolder + "/" + this.apiPackage().replace('.', '/');
    }

    public String apiFilename(String templateName, String tag) {
        if (ServiceType.CONSUMER.getValue().equals(this.additionalProperties.get("serviceType")) || ServiceType.CONSUMER.getValue().equals(this.additionalProperties.get(templateName))) {
            String suffix = (String)this.apiTemplateFiles().get(templateName);
            return this.apiConsumerFolder() + File.separator + this.toApiFilename(tag) + suffix;
        }
        return super.apiFilename(templateName, tag);
    }

    private String apiConsumerFolder() {
        return this.outputFolder + "/" + this.currentDirectoryStrategy.consumerDirectory() + "/" + this.sourceFolder + "/" + this.apiPackage().replace('.', '/');
    }

    public String modelFileFolder() {
        return this.outputFolder + "/" + this.currentDirectoryStrategy.modelDirectory() + "/" + this.sourceFolder + "/" + this.modelPackage().replace('.', '/');
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        Map operations = (Map)objs.get("operations");
        String classnameImpl = (String)operations.get("classname") + "Impl";
        operations.put("classnameImpl", classnameImpl);
        this.additionalProperties.put("classnameImpl", classnameImpl);
        return super.postProcessOperationsWithModels(objs, allModels);
    }

    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    public String getName() {
        return "SpringCloud";
    }

    public String getHelp() {
        return "Generates a SpringCloud server library.";
    }
}

