/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.aggregate;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridCoverageProcessor;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.IllegalGridGeometryException;
import org.apache.sis.coverage.grid.PixelInCell;
import org.apache.sis.image.Colorizer;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.crs.DefaultTemporalCRS;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.MemoryGridCoverageResource;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.aggregate.AggregatedResource;
import org.apache.sis.storage.aggregate.BandAggregateGridResource;
import org.apache.sis.storage.aggregate.DimensionAppender;
import org.apache.sis.storage.aggregate.GridSlice;
import org.apache.sis.storage.aggregate.Group;
import org.apache.sis.storage.aggregate.GroupAggregate;
import org.apache.sis.storage.aggregate.GroupBySample;
import org.apache.sis.storage.aggregate.MergeStrategy;
import org.apache.sis.storage.base.PseudoResource;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.internal.shared.Numerics;
import org.opengis.metadata.spatial.DimensionNameType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.util.GenericName;

public final class CoverageAggregator
extends Group<GroupBySample> {
    private final StoreListeners listeners;
    private final Map<Set<Resource>, Queue<Aggregate>> aggregates;
    private volatile MergeStrategy strategy;
    private int sequence;

    public CoverageAggregator() {
        this((StoreListeners)null);
    }

    public CoverageAggregator(StoreListeners listeners) {
        this(listeners, new GridCoverageProcessor());
    }

    CoverageAggregator(StoreListeners listeners, GridCoverageProcessor processor) {
        super(processor);
        this.listeners = listeners;
        this.aggregates = new HashMap<Set<Resource>, Queue<Aggregate>>();
    }

    @Override
    final String createName(Locale locale) {
        return this.listeners != null ? this.listeners.getSourceName() : null;
    }

    private PseudoResource asPseudoResource() {
        return new PseudoResource(this.listeners);
    }

    public void add(GridCoverage coverage) {
        try {
            this.add(new MemoryGridCoverageResource(this.asPseudoResource(), null, coverage, this.processor));
        }
        catch (DataStoreException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NoninvertibleTransformException) {
                throw new IllegalGridGeometryException(cause);
            }
            throw new BackingStoreException((Throwable)e);
        }
    }

    public void add(GridCoverage coverage, GridGeometry dimToAdd) {
        this.add(this.processor.appendDimensions(coverage, dimToAdd));
    }

    public void add(GridCoverage coverage, double lower, double span, SingleCRS crs) {
        this.add(this.processor.appendDimension(coverage, lower, span, crs));
    }

    public void add(GridCoverage coverage, Instant lower, Duration span) {
        this.add(this.processor.appendDimension(coverage, lower, span));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(GridCoverageResource resource) throws DataStoreException {
        GridSlice slice;
        GroupBySample bySample;
        int order;
        block7: {
            List<SampleDimension> ranges = resource.getSampleDimensions();
            List list = this.members;
            synchronized (list) {
                order = this.sequence++;
                int i = this.members.size();
                while (--i >= 0) {
                    bySample = (GroupBySample)this.members.get(i);
                    if (!bySample.accepts(ranges)) continue;
                    break block7;
                }
                bySample = new GroupBySample(this, ranges);
                this.members.add(bySample);
            }
        }
        try {
            slice = new GridSlice(order, resource, bySample, this.strategy);
        }
        catch (NoninvertibleTransformException e) {
            throw new DataStoreContentException(e);
        }
        assert (bySample.contains(slice));
    }

    public void add(GridCoverageResource resource, GridGeometry dimToAdd) throws DataStoreException {
        this.add(DimensionAppender.create(this.processor, resource, dimToAdd));
    }

    public void add(GridCoverageResource resource, double lower, double span, SingleCRS crs) throws DataStoreException {
        long index = Numerics.roundAndClamp((double)(lower / span));
        long[] indices = new long[]{index};
        DimensionNameType[] names = new DimensionNameType[]{GridExtent.typeFromAxis((CoordinateSystemAxis)crs.getCoordinateSystem().getAxis(0)).orElse(null)};
        GridExtent extent = new GridExtent(names, indices, indices, true);
        LinearTransform gridToCRS = MathTransforms.linear((double)span, (double)Math.fma((double)index, -span, lower));
        this.add(resource, new GridGeometry(extent, PixelInCell.CELL_CORNER, (MathTransform)gridToCRS, (CoordinateReferenceSystem)crs));
    }

    public void add(GridCoverageResource resource, Instant lower, Duration span) throws DataStoreException {
        DefaultTemporalCRS crs = DefaultTemporalCRS.castOrCopy((TemporalCRS)CommonCRS.defaultTemporal());
        double scale = crs.toValue(span);
        double offset = crs.toValue(lower);
        long index = Numerics.roundAndClamp((double)(offset / scale));
        offset = crs.toValue(lower.minus(span.multipliedBy(index)));
        GridExtent extent = new GridExtent(DimensionNameType.TIME, index, index, true);
        LinearTransform gridToCRS = MathTransforms.linear((double)scale, (double)offset);
        this.add(resource, new GridGeometry(extent, PixelInCell.CELL_CORNER, (MathTransform)gridToCRS, (CoordinateReferenceSystem)crs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addComponents(Aggregate resource) throws DataStoreException {
        boolean hasDuplicated = false;
        Set components = Collections.newSetFromMap(new IdentityHashMap());
        for (Resource resource2 : resource.components()) {
            if (components.add(resource2)) {
                if (resource2 instanceof GridCoverageResource) {
                    this.add((GridCoverageResource)resource2);
                    continue;
                }
                if (!(resource2 instanceof Aggregate)) continue;
                this.addComponents((Aggregate)resource2);
                continue;
            }
            hasDuplicated = true;
        }
        if (!hasDuplicated && !components.isEmpty()) {
            Map<Set<Resource>, Queue<Aggregate>> map = this.aggregates;
            synchronized (map) {
                this.aggregates.computeIfAbsent(components, k -> new ArrayDeque(1)).add(resource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Optional<Aggregate> existingAggregate(Resource[] components) {
        Set key = Collections.newSetFromMap(new IdentityHashMap());
        if (Collections.addAll(key, components)) {
            Queue<Aggregate> r;
            Map<Set<Resource>, Queue<Aggregate>> map = this.aggregates;
            synchronized (map) {
                r = this.aggregates.get(key);
            }
            if (r != null) {
                return Optional.ofNullable(r.poll());
            }
        }
        return Optional.empty();
    }

    public void addAll(Stream<? extends GridCoverageResource> resources) throws DataStoreException {
        try {
            resources.forEach(resource -> {
                try {
                    this.add((GridCoverageResource)resource);
                }
                catch (DataStoreException e) {
                    throw new BackingStoreException((Throwable)e);
                }
            });
        }
        catch (BackingStoreException e) {
            throw (DataStoreException)e.unwrapOrRethrow(DataStoreException.class);
        }
    }

    public void addRangeAggregate(GridCoverageResource ... sources) throws DataStoreException {
        this.addRangeAggregate(sources, (int[][])null);
    }

    public void addRangeAggregate(GridCoverageResource[] sources, int[][] bandsPerSource) throws DataStoreException {
        if (sources.length != 0) {
            this.add(BandAggregateGridResource.create(this.asPseudoResource(), sources, bandsPerSource, this.processor));
        }
    }

    public Colorizer getColorizer() {
        return this.processor.getColorizer();
    }

    public void setColorizer(Colorizer colorizer) {
        this.processor.setColorizer(colorizer);
    }

    public MergeStrategy getMergeStrategy() {
        return this.strategy;
    }

    public void setMergeStrategy(MergeStrategy strategy) {
        this.strategy = strategy;
    }

    public synchronized Resource build(GenericName identifier) {
        GroupAggregate aggregate = this.prepareAggregate(this.listeners);
        aggregate.fillWithChildAggregates(this, GroupBySample::createComponents);
        Resource result = aggregate.simplify(this);
        if (result instanceof AggregatedResource) {
            ((AggregatedResource)result).identifier = identifier;
        }
        return result;
    }
}

