/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.map;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.Optional;
import java.util.logging.Logger;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.HLineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.VLineTo;
import org.apache.sis.gui.internal.LogHandler;
import org.apache.sis.gui.map.MapCanvas;
import org.apache.sis.portrayal.CanvasFollower;
import org.apache.sis.portrayal.PlanarCanvas;
import org.apache.sis.portrayal.TransformChangeEvent;
import org.apache.sis.util.logging.Logging;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

public class GestureFollower
extends CanvasFollower
implements EventHandler<MouseEvent> {
    private static final double CURSOR_INNER_RADIUS = 7.5;
    private static final double CURSOR_OUTER_RADIUS = 20.5;
    private static final PathElement[] CURSOR_SHAPE = new PathElement[]{new MoveTo(0.5, -20.5), new VLineTo(-7.5), new MoveTo(0.5, 20.5), new VLineTo(7.5), new MoveTo(-20.5, 0.5), new HLineTo(-7.5), new MoveTo(20.5, 0.5), new HLineTo(7.5)};
    private static final DropShadow CURSOR_EFFECT = new DropShadow(BlurType.ONE_PASS_BOX, Color.DEEPPINK, 5.0, 0.0, 0.0, 0.0);
    public final BooleanProperty transformEnabled;
    public final BooleanProperty cursorEnabled;
    private boolean cursorSourceValid;
    private final Point2D.Double cursorSourcePosition;
    private final Point2D.Double cursorTargetPosition;
    private Path cursor;

    public GestureFollower(MapCanvas source, MapCanvas target) {
        super((PlanarCanvas)source, (PlanarCanvas)target);
        super.setDisabled(true);
        this.cursorSourcePosition = new Point2D.Double();
        this.cursorTargetPosition = new Point2D.Double();
        this.transformEnabled = new SimpleBooleanProperty((Object)this, "transformEnabled");
        this.cursorEnabled = new SimpleBooleanProperty((Object)this, "cursorEnabled");
        this.transformEnabled.addListener((p, o, n) -> this.setDisabled(n == false));
        this.cursorEnabled.addListener((p, o, n) -> this.followCursor((boolean)n));
    }

    private void followCursor(boolean enabled) {
        Pane pane = ((MapCanvas)this.source).floatingPane;
        if (enabled) {
            if (this.cursor == null) {
                this.cursor = new Path(CURSOR_SHAPE);
                this.cursor.setStrokeWidth(3.0);
                this.cursor.setStroke((Paint)Color.LIGHTPINK);
                this.cursor.setEffect((Effect)CURSOR_EFFECT);
                this.cursor.setMouseTransparent(true);
                this.cursor.setManaged(false);
                this.cursor.setSmooth(false);
                this.cursor.setCache(true);
            }
            ((MapCanvas)this.target).floatingPane.getChildren().add((Object)this.cursor);
            pane.addEventHandler(MouseEvent.MOUSE_ENTERED, (EventHandler)this);
            pane.addEventHandler(MouseEvent.MOUSE_EXITED, (EventHandler)this);
            pane.addEventHandler(MouseEvent.MOUSE_MOVED, (EventHandler)this);
            pane.addEventHandler(MouseEvent.MOUSE_DRAGGED, (EventHandler)this);
            this.cursorSourceValid = true;
        } else {
            this.cursorSourceValid = false;
            pane.removeEventHandler(MouseEvent.MOUSE_ENTERED, (EventHandler)this);
            pane.removeEventHandler(MouseEvent.MOUSE_EXITED, (EventHandler)this);
            pane.removeEventHandler(MouseEvent.MOUSE_MOVED, (EventHandler)this);
            pane.removeEventHandler(MouseEvent.MOUSE_DRAGGED, (EventHandler)this);
            if (this.cursor != null) {
                ((MapCanvas)this.target).floatingPane.getChildren().remove((Object)this.cursor);
            }
        }
    }

    public Optional<Point2D> getSourceDisplayPOI() {
        if (this.cursorSourceValid) {
            return Optional.of(this.cursorSourcePosition);
        }
        return super.getSourceDisplayPOI();
    }

    public void handle(MouseEvent event) {
        this.cursorSourcePosition.x = event.getX();
        this.cursorSourcePosition.y = event.getY();
        this.cursorSourceValid = true;
        EventType type = event.getEventType();
        if (type == MouseEvent.MOUSE_MOVED) {
            this.updateCursorPosition();
        } else if (type == MouseEvent.MOUSE_ENTERED) {
            this.cursor.setVisible(true);
            this.updateCursorPosition();
        } else if (type == MouseEvent.MOUSE_EXITED) {
            this.cursor.setVisible(false);
        }
    }

    private void updateCursorPosition() {
        MathTransform2D tr = this.getDisplayTransform().orElse(null);
        if (tr != null) {
            try {
                Point2D p = tr.transform((Point2D)this.cursorSourcePosition, (Point2D)this.cursorTargetPosition);
                this.cursor.setTranslateX(p.getX());
                this.cursor.setTranslateY(p.getY());
            }
            catch (TransformException e) {
                this.cursorSourceValid = false;
                this.cursor.setVisible(false);
                Logging.recoverableException((Logger)LogHandler.LOGGER, GestureFollower.class, (String)"handle", (Throwable)e);
            }
        }
    }

    protected boolean filter(TransformChangeEvent event) {
        return event.getReason() == TransformChangeEvent.Reason.INTERIM;
    }

    protected void transformedSource(TransformChangeEvent event) {
        super.transformedSource(event);
        if (this.cursorSourceValid) {
            AffineTransform change = event.getDisplayChange2D().orElse(null);
            if (change == null) {
                this.cursorSourceValid = false;
                this.cursor.setVisible(false);
            } else if (event.getReason() != TransformChangeEvent.Reason.INTERIM) {
                change.transform(this.cursorSourcePosition, this.cursorSourcePosition);
                this.updateCursorPosition();
            } else {
                try {
                    change.inverseTransform(this.cursorSourcePosition, this.cursorSourcePosition);
                    this.updateCursorPosition();
                }
                catch (NoninvertibleTransformException e) {
                    this.cursorSourceValid = false;
                    this.cursor.setVisible(false);
                }
            }
        }
    }

    public void dispose() {
        this.followCursor(false);
        super.dispose();
    }
}

