/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Filter;
import org.apache.sis.filter.Optimization;
import org.opengis.util.ScopedName;

abstract class DynamicOptimization<T> {
    private final Map<DefaultFeatureType, T> cache = new IdentityHashMap<DefaultFeatureType, T>();

    protected DynamicOptimization() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final T delegate(DefaultFeatureType type) {
        Map<DefaultFeatureType, T> map = this.cache;
        synchronized (map) {
            return (T)this.cache.computeIfAbsent(type, key -> {
                Optimization optimizer = new Optimization();
                optimizer.setFinalFeatureType((DefaultFeatureType)key);
                return this.optimizeOriginal(optimizer);
            });
        }
    }

    protected abstract T optimizeOriginal(Optimization var1);

    public static Filter<AbstractFeature> of(Filter<AbstractFeature> original) {
        if (original instanceof OfFilter) {
            return original;
        }
        return new OfFilter(original);
    }

    public static <R> Filter<R> ofAny(Filter<R> original) {
        if (original.getResourceClass().isAssignableFrom(AbstractFeature.class)) {
            return DynamicOptimization.of(original);
        }
        return original;
    }

    public static <V> Expression<AbstractFeature, V> of(Expression<AbstractFeature, V> original) {
        if (original instanceof OfExpression) {
            return original;
        }
        return new OfExpression<V>(original);
    }

    public static <R, V> Expression<R, V> ofAny(Expression<R, V> original) {
        if (original.getResourceClass().isAssignableFrom(AbstractFeature.class)) {
            return DynamicOptimization.of(original);
        }
        return original;
    }

    private static final class OfFilter
    extends DynamicOptimization<Filter<AbstractFeature>>
    implements Optimization.OnFilter<AbstractFeature> {
        private final Filter<AbstractFeature> original;
        private Entry last;

        OfFilter(Filter<AbstractFeature> original) {
            this.original = original;
            this.last = new Entry(null, original);
        }

        @Override
        protected Filter<AbstractFeature> optimizeOriginal(Optimization optimizer) {
            return optimizer.apply(this.original);
        }

        @Override
        public Filter<AbstractFeature> optimize(Optimization optimizer) {
            Object result = this.optimizeOriginal(optimizer);
            return result != this.original ? OfFilter.of((Filter<AbstractFeature>)result) : this;
        }

        @Override
        public boolean test(AbstractFeature feature) {
            DefaultFeatureType type = feature.getType();
            Entry entry = this.last;
            if (entry.type != type) {
                this.last = entry = new Entry(type, (Filter)this.delegate(type));
            }
            return entry.delegate.test(feature);
        }

        @Override
        public Enum<?> getOperatorType() {
            return this.original.getOperatorType();
        }

        @Override
        public Class<? super AbstractFeature> getResourceClass() {
            return this.original.getResourceClass();
        }

        @Override
        public List<Expression<AbstractFeature, ?>> getExpressions() {
            return this.original.getExpressions();
        }

        public String toString() {
            return this.original.toString();
        }

        private static final class Entry {
            final DefaultFeatureType type;
            final Filter<AbstractFeature> delegate;

            Entry(DefaultFeatureType type, Filter<AbstractFeature> delegate) {
                this.type = type;
                this.delegate = delegate;
            }
        }
    }

    private static final class OfExpression<V>
    extends DynamicOptimization<Expression<AbstractFeature, ? extends V>>
    implements Optimization.OnExpression<AbstractFeature, V> {
        private final Expression<AbstractFeature, ? extends V> original;
        private Entry<V> last;

        OfExpression(Expression<AbstractFeature, ? extends V> original) {
            this.original = original;
            this.last = new Entry<V>(null, original);
        }

        @Override
        protected Expression<AbstractFeature, ? extends V> optimizeOriginal(Optimization optimizer) {
            return optimizer.apply(this.original);
        }

        @Override
        public Expression<AbstractFeature, ? extends V> optimize(Optimization optimizer) {
            Object result = this.optimizeOriginal(optimizer);
            return result != this.original ? OfExpression.of(result) : this;
        }

        @Override
        public V apply(AbstractFeature feature) {
            DefaultFeatureType type = feature.getType();
            Entry<V> entry = this.last;
            if (entry.type != type) {
                this.last = entry = new Entry(type, (Expression)this.delegate(type));
            }
            return entry.delegate.apply(feature);
        }

        @Override
        public <N> Expression<AbstractFeature, N> toValueType(Class<N> target) {
            Expression<AbstractFeature, N> other = this.original.toValueType(target);
            return other != this.original ? OfExpression.of(other) : this;
        }

        @Override
        public ScopedName getFunctionName() {
            return this.original.getFunctionName();
        }

        @Override
        public Class<? super AbstractFeature> getResourceClass() {
            return this.original.getResourceClass();
        }

        @Override
        public List<Expression<AbstractFeature, ?>> getParameters() {
            return this.original.getParameters();
        }

        public String toString() {
            return this.original.toString();
        }

        private static final class Entry<V> {
            final DefaultFeatureType type;
            final Expression<AbstractFeature, ? extends V> delegate;

            Entry(DefaultFeatureType type, Expression<AbstractFeature, ? extends V> delegate) {
                this.type = type;
                this.delegate = delegate;
            }
        }
    }
}

