/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.component.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.sling.commons.osgi.PropertiesUtil;

public class SettingsUtils {
    public static final String COMPONENT_NAME_DEFAULT = "(name=default)";
    private static final String COMPONENT_ROOT = "";
    private static final char COMPONENT_DELIM = '/';
    private static final char COMPONENT_MAP_BEGIN = '[';
    private static final char COMPONENT_MAP_END = ']';
    private static final char COMPONENT_MAP_DELIM = '=';

    public static Map<String, Object> parseLines(String[] lines) {
        Map<String, Object> result = new HashMap<String, Object>();
        Map<String, List<String>> linesMap = SettingsUtils.toLinesMap(lines);
        for (Map.Entry<String, List<String>> entry : linesMap.entrySet()) {
            String componentName = entry.getKey();
            List<String> var = entry.getValue();
            String[] componentLines = var.toArray(new String[var.size()]);
            if (COMPONENT_ROOT.equals(componentName)) {
                Map map = PropertiesUtil.toMap((Object)componentLines, (String[])new String[0]);
                result.putAll(map);
                continue;
            }
            Map<String, Object> componentMap = SettingsUtils.parseLines(componentLines);
            result.put(componentName, componentMap);
        }
        result = SettingsUtils.collapseMap(result);
        return result;
    }

    private static Map<String, List<String>> toLinesMap(String[] lines) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (String line : lines) {
            int firstMapDelim = line.indexOf(61);
            if (firstMapDelim < 0) continue;
            int firstDelim = line.substring(0, firstMapDelim).indexOf(47);
            String key = COMPONENT_ROOT;
            String value = line;
            if (firstDelim >= 0) {
                key = line.substring(0, firstDelim);
                value = line.substring(firstDelim + 1);
            }
            if (!result.containsKey(key)) {
                result.put(key, new ArrayList());
            }
            List exitingLines = (List)result.get(key);
            exitingLines.add(value);
        }
        return result;
    }

    private static Map<String, Object> collapseMap(Map<String, Object> valueMap) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : valueMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            int beginDelim = key.indexOf(91);
            int endDelim = key.indexOf(93);
            if (beginDelim >= 0 && endDelim > beginDelim) {
                Object existingObject;
                String newKey = key.substring(0, beginDelim);
                String partialKey = key.substring(beginDelim + 1, endDelim);
                boolean isNumber = SettingsUtils.isNumber(partialKey);
                if (!result.containsKey(newKey)) {
                    result.put(newKey, isNumber ? new ArrayList() : new HashMap());
                }
                if ((existingObject = result.get(newKey)) instanceof Map) {
                    ((Map)existingObject).put(partialKey, value);
                    continue;
                }
                if (!(existingObject instanceof List)) continue;
                ((List)existingObject).add(value);
                continue;
            }
            result.put(key, value);
        }
        return result;
    }

    private static boolean isNumber(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static <AType> Map<String, AType> toMap(List<AType> aList, String prefix) {
        TreeMap<String, AType> result = new TreeMap<String, AType>();
        for (int i = 0; i < aList.size(); ++i) {
            result.put(prefix + i, aList.get(i));
        }
        return result;
    }

    public static Map<String, String> toUriMap(Object obj) {
        Map<String, String> uriMap = PropertiesUtil.toMap((Object)obj, (String[])new String[0]);
        if (uriMap.size() == 0) {
            String[] endpoints = PropertiesUtil.toStringArray((Object)obj, (String[])new String[0]);
            endpoints = SettingsUtils.removeEmptyEntries(endpoints);
            uriMap = SettingsUtils.toMap(Arrays.asList(endpoints), "endpoint");
        }
        return uriMap;
    }

    public static String[] removeEmptyEntries(String[] array) {
        if (array == null || array.length == 0) {
            return array;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String entry : array) {
            if ((entry = SettingsUtils.removeEmptyEntry(entry)) == null) continue;
            result.add(entry);
        }
        if (result.size() == 0) {
            return null;
        }
        return result.toArray(new String[result.size()]);
    }

    public static String[] removeEmptyEntries(String[] array, String[] defaultArray) {
        String[] result = SettingsUtils.removeEmptyEntries(array);
        if (result == null) {
            return defaultArray;
        }
        return result;
    }

    public static String removeEmptyEntry(String entry) {
        if (entry == null) {
            return null;
        }
        if ((entry = entry.trim()).length() == 0) {
            return null;
        }
        return entry;
    }

    public static Map<String, String> removeEmptyEntries(Map<String, String> map) {
        if (map == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = SettingsUtils.removeEmptyEntry(entry.getKey());
            String value = SettingsUtils.removeEmptyEntry(entry.getValue());
            if (key == null || value == null) continue;
            result.put(key, value);
        }
        if (result.size() == 0) {
            return null;
        }
        return result;
    }

    public static Map<String, String> expandUriMap(Map<String, String> map, Map<String, String> aliases) {
        TreeMap<String, String> result = new TreeMap<String, String>(map);
        for (Map.Entry<String, String> aliasEntry : aliases.entrySet()) {
            if (aliasEntry.getValue() == null || !map.containsKey(aliasEntry.getValue())) continue;
            result.put(aliasEntry.getKey(), map.get(aliasEntry.getValue()));
        }
        return result;
    }
}

