/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.shared;

import java.io.Closeable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExponentialBackOff
implements Closeable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final long startDelay;
    private final long maxDelay;
    private final boolean randomDelay;
    private final Runnable checkCallback;
    private final ScheduledExecutorService executor;
    private final AtomicBoolean isScheduled;
    private long currentMaxDelay;
    private long lastCheck;

    public ExponentialBackOff(long startDelay, long maxDelay, boolean randomDelay, Runnable checkCallback) {
        this.startDelay = startDelay;
        this.maxDelay = maxDelay;
        this.randomDelay = randomDelay;
        this.checkCallback = checkCallback;
        this.executor = Executors.newScheduledThreadPool(1);
        this.currentMaxDelay = this.startDelay;
        this.isScheduled = new AtomicBoolean();
        this.lastCheck = 0L;
    }

    @Override
    public void close() {
        this.log.info("Shutting down exponential backoff executor");
        this.executor.shutdown();
        this.executor.shutdownNow();
        try {
            this.executor.awaitTermination(100L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.log.info("Shutdown completed");
    }

    public void startChecks() {
        if (this.noRecentErrors()) {
            this.log.info("No recent errors. Starting with initial delay {}", (Object)this.startDelay);
            this.currentMaxDelay = this.startDelay;
        }
        this.scheduleCheck();
    }

    private boolean noRecentErrors() {
        long timeSinceLastError = System.currentTimeMillis() - this.lastCheck;
        return timeSinceLastError > this.currentMaxDelay * 2L;
    }

    private synchronized void scheduleCheck() {
        if (this.isScheduled.compareAndSet(false, true)) {
            long delay = this.computeDelay();
            this.log.info("Scheduling next check in {} ms with maximum delay of {} ms.", (Object)delay, (Object)this.currentMaxDelay);
            this.executor.schedule(this::check, delay, TimeUnit.MILLISECONDS);
            this.currentMaxDelay = Math.min(this.currentMaxDelay * 2L, this.maxDelay);
        }
    }

    private long computeDelay() {
        return this.randomDelay ? ThreadLocalRandom.current().nextLong(this.currentMaxDelay) + 1L : this.currentMaxDelay;
    }

    private void check() {
        try {
            this.lastCheck = System.currentTimeMillis();
            this.isScheduled.set(false);
            this.checkCallback.run();
        }
        catch (RuntimeException e) {
            this.scheduleCheck();
        }
    }
}

