/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.kafka;

import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.util.Objects;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.sling.distribution.journal.MessageHandler;
import org.apache.sling.distribution.journal.MessageInfo;
import org.apache.sling.distribution.journal.kafka.KafkaMessageInfo;

public class JsonRecordHandler<T> {
    public final MessageHandler<T> handler;
    public final ObjectReader reader;

    public JsonRecordHandler(MessageHandler<T> handler, ObjectReader reader) {
        this.reader = reader;
        this.handler = Objects.requireNonNull(handler);
    }

    public void accept(ConsumerRecord<String, String> record) throws IOException {
        KafkaMessageInfo info = new KafkaMessageInfo(record);
        String payload = (String)record.value();
        Object message = this.reader.readValue(payload);
        this.handler.handle((MessageInfo)info, message);
    }
}

