/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.peaberry.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import org.ops4j.peaberry.Import;
import org.ops4j.peaberry.ServiceException;
import org.ops4j.peaberry.builders.ImportDecorator;
import org.ops4j.peaberry.internal.ComputedMapFactory;
import org.ops4j.peaberry.internal.ConcurrentImport;
import org.ops4j.peaberry.internal.ConcurrentReferenceHashMap;
import org.ops4j.peaberry.internal.ImportProxyClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ServiceProxyFactory {
    private ServiceProxyFactory() {
    }

    static <T> Iterable<T> serviceProxies(Class<T> clazz, final Iterable<Import<T>> services, final ImportDecorator<? super T> decorator) {
        final Constructor<T> ctor = ImportProxyClassLoader.getProxyConstructor(clazz);
        final ConcurrentMap PROXY_CACHE = ComputedMapFactory.computedMap(ConcurrentReferenceHashMap.ReferenceType.WEAK, ConcurrentReferenceHashMap.ReferenceType.SOFT, 8, new ComputedMapFactory.Function<Import<T>, T>(){

            @Override
            public T compute(Import<T> service) {
                return ServiceProxyFactory.buildProxy(ctor, decorator, service);
            }
        });
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    private final Iterator<Import<T>> i;
                    {
                        this.i = services.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public T next() {
                        return PROXY_CACHE.get(this.i.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            public String toString() {
                StringBuilder buf = new StringBuilder().append('[');
                String delim = "";
                for (Object t : this) {
                    buf.append(delim).append(t);
                    delim = ", ";
                }
                return buf.append(']').toString();
            }
        };
    }

    static <T> T serviceProxy(Class<T> clazz, Iterable<Import<T>> services, ImportDecorator<? super T> decorator) {
        return ServiceProxyFactory.buildProxy(ImportProxyClassLoader.getProxyConstructor(clazz), decorator, new ConcurrentImport<T>(services));
    }

    static <T> T buildProxy(Constructor<T> constructor, ImportDecorator<? super T> decorator, Import<T> service) {
        try {
            return constructor.newInstance(null == decorator ? service : decorator.decorate(service));
        }
        catch (InstantiationException e) {
            throw new ServiceException(e);
        }
        catch (IllegalAccessException e) {
            throw new ServiceException(e);
        }
        catch (InvocationTargetException e) {
            throw new ServiceException(e);
        }
    }
}

