/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.io.json;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Bundles;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.Configurations;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionState;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.Extensions;
import org.apache.sling.feature.MatchingRequirement;
import org.apache.sling.feature.Prototype;
import org.apache.sling.feature.io.impl.felix.configurator.impl.json.JSMin;
import org.apache.sling.feature.io.impl.felix.configurator.impl.json.JSONUtil;
import org.apache.sling.feature.io.impl.felix.configurator.impl.json.TypeConverter;
import org.apache.sling.feature.io.impl.felix.configurator.impl.model.Config;
import org.apache.sling.feature.io.impl.felix.utils.resource.CapabilityImpl;
import org.apache.sling.feature.io.impl.felix.utils.resource.RequirementImpl;
import org.apache.sling.feature.io.json.JSONConstants;
import org.apache.sling.feature.io.json.ManifestUtils;
import org.osgi.resource.Capability;
import org.osgi.resource.Resource;

abstract class JSONReaderBase {
    protected final String location;
    protected final String exceptionPrefix;

    JSONReaderBase(String location) {
        this.location = location;
        this.exceptionPrefix = location == null ? "" : location + " : ";
    }

    protected String minify(Reader reader) throws IOException {
        String contents;
        try (StringWriter out = new StringWriter();){
            JSMin min = new JSMin(reader, out);
            min.jsmin();
            contents = ((Object)out).toString();
        }
        return contents;
    }

    protected Map<String, Object> getJsonMap(JsonObject json) {
        Map m = (Map)JSONUtil.getValue((JsonValue)json);
        this.removeComments(m);
        return m;
    }

    private void removeComments(Map<String, Object> m) {
        Iterator<Map.Entry<String, Object>> it = m.entrySet().iterator();
        while (it.hasNext()) {
            Object embedded;
            Map.Entry<String, Object> entry = it.next();
            if (entry.getKey().startsWith("#")) {
                it.remove();
                continue;
            }
            if (entry.getValue() instanceof Map) {
                embedded = (Map)entry.getValue();
                this.removeComments((Map<String, Object>)embedded);
                continue;
            }
            if (!(entry.getValue() instanceof Collection)) continue;
            embedded = (Collection)entry.getValue();
            this.removeComments((Collection<?>)embedded);
        }
    }

    private void removeComments(Collection<?> embedded) {
        for (Object el : embedded) {
            if (el instanceof Collection) {
                this.removeComments((Collection)el);
                continue;
            }
            if (!(el instanceof Map)) continue;
            this.removeComments((Map)el);
        }
    }

    protected String getProperty(Map<String, Object> map, String key) throws IOException {
        Object val = map.get(key);
        if (val != null) {
            this.checkType(key, val, String.class);
            return val.toString();
        }
        return null;
    }

    protected Map<String, String> readVariables(Map<String, Object> map, Map<String, String> kvMap) throws IOException {
        HashMap<String, String> variables = new HashMap<String, String>();
        if (map.containsKey("variables")) {
            Object variablesObj = map.get("variables");
            this.checkType("variables", variablesObj, Map.class);
            Map vars = (Map)variablesObj;
            for (Map.Entry entry : vars.entrySet()) {
                Object val = entry.getValue();
                this.checkType("variable value", val, String.class, Boolean.class, Number.class, null);
                String key = (String)entry.getKey();
                if (kvMap.get(key) != null) {
                    throw new IOException(this.exceptionPrefix + "Duplicate variable " + key);
                }
                String value = val == null ? null : val.toString();
                kvMap.put(key, value);
                variables.put(key, value);
            }
        }
        return variables;
    }

    protected void readBundles(Map<String, Object> map, Bundles container, Configurations configContainer) throws IOException {
        if (map.containsKey("bundles")) {
            Object bundlesObj = map.get("bundles");
            this.checkType("bundles", bundlesObj, List.class);
            ArrayList<Artifact> list = new ArrayList<Artifact>();
            this.readArtifacts("bundles", "bundle", list, bundlesObj, configContainer);
            for (Artifact a : list) {
                if (container.containsExact(a.getId())) {
                    throw new IOException(this.exceptionPrefix + "Duplicate identical bundle " + a.getId().toMvnId());
                }
                try {
                    a.getStartOrder();
                }
                catch (IllegalArgumentException nfe) {
                    throw new IOException(this.exceptionPrefix + "Illegal start order '" + (String)a.getMetadata().get("start-order") + "'");
                }
                container.add(a);
            }
        }
    }

    protected void readArtifacts(String section, String artifactType, List<Artifact> artifacts, Object listObj, Configurations container) throws IOException {
        this.checkType(section, listObj, List.class);
        List list = (List)listObj;
        for (Object entry : list) {
            Artifact artifact;
            this.checkType(artifactType, entry, Map.class, String.class);
            if (entry instanceof String) {
                if (entry.toString().startsWith("#")) continue;
                artifact = new Artifact(ArtifactId.parse((String)((String)entry)));
            } else {
                Map bundleObj = (Map)entry;
                if (!bundleObj.containsKey("id")) {
                    throw new IOException(this.exceptionPrefix + " " + artifactType + " is missing required artifact id");
                }
                this.checkType(artifactType + " " + "id", bundleObj.get("id"), String.class);
                ArtifactId id = ArtifactId.parse((String)bundleObj.get("id").toString());
                artifact = new Artifact(id);
                for (Map.Entry metadataEntry : bundleObj.entrySet()) {
                    String key = (String)metadataEntry.getKey();
                    if (JSONConstants.ARTIFACT_KNOWN_PROPERTIES.contains(key)) continue;
                    this.checkType(artifactType + " metadata " + key, metadataEntry.getValue(), String.class, Number.class, Boolean.class);
                    artifact.getMetadata().put(key, metadataEntry.getValue().toString());
                }
                if (bundleObj.containsKey("configurations")) {
                    this.checkType(artifactType + " configurations", bundleObj.get("configurations"), Map.class);
                    this.addConfigurations(bundleObj, artifact, container);
                }
            }
            artifacts.add(artifact);
        }
    }

    protected void addConfigurations(Map<String, Object> map, Artifact artifact, Configurations container) throws IOException {
        JSONUtil.Report report = new JSONUtil.Report();
        List<Config> configs = JSONUtil.readConfigurationsJSON(new TypeConverter(null), 0L, "", (Map)map.get("configurations"), report);
        if (!report.errors.isEmpty() || !report.warnings.isEmpty()) {
            StringBuilder builder = new StringBuilder(this.exceptionPrefix);
            builder.append("Errors in configurations:");
            for (String w : report.warnings) {
                builder.append("\n");
                builder.append(w);
            }
            for (String e : report.errors) {
                builder.append("\n");
                builder.append(e);
            }
            throw new IOException(builder.toString());
        }
        for (Config c : configs) {
            Configuration config = new Configuration(c.getPid());
            Enumeration<String> keyEnum = c.getProperties().keys();
            while (keyEnum.hasMoreElements()) {
                String key = keyEnum.nextElement();
                Object val = c.getProperties().get(key);
                config.getProperties().put(key, val);
            }
            if (config.getProperties().get(":configurator:feature:service.bundleLocation") != null) {
                throw new IOException(this.exceptionPrefix + "Configuration must not define property " + ":configurator:feature:service.bundleLocation");
            }
            if (artifact != null) {
                config.getProperties().put(":configurator:feature:service.bundleLocation", artifact.getId().toMvnId());
            }
            for (Configuration current : container) {
                if (!current.equals(config)) continue;
                throw new IOException(this.exceptionPrefix + "Duplicate configuration " + config);
            }
            container.add((Object)config);
        }
    }

    protected void readConfigurations(Map<String, Object> map, Configurations container) throws IOException {
        if (map.containsKey("configurations")) {
            this.checkType("configurations", map.get("configurations"), Map.class);
            this.addConfigurations(map, null, container);
        }
    }

    protected void readFrameworkProperties(Map<String, Object> map, Map<String, String> container) throws IOException {
        if (map.containsKey("framework-properties")) {
            Object propsObj = map.get("framework-properties");
            this.checkType("framework-properties", propsObj, Map.class);
            Map props = (Map)propsObj;
            for (Map.Entry entry : props.entrySet()) {
                this.checkType("framework property value", entry.getValue(), String.class, Boolean.class, Number.class);
                if (container.get(entry.getKey()) != null) {
                    throw new IOException(this.exceptionPrefix + "Duplicate framework property " + (String)entry.getKey());
                }
                container.put((String)entry.getKey(), entry.getValue().toString());
            }
        }
    }

    protected void readExtensions(Map<String, Object> map, List<String> keywords, Extensions container, Configurations configContainer) throws IOException {
        HashSet<String> keySet = new HashSet<String>(map.keySet());
        keySet.removeAll(keywords);
        for (String key : keySet) {
            boolean opt;
            String state;
            String name;
            String type;
            int sep;
            int pos = key.indexOf(58);
            String postfix = pos == -1 ? null : key.substring(pos + 1);
            int n = sep = postfix == null ? key.indexOf(124) : postfix.indexOf(124);
            if (pos == -1) {
                type = ExtensionType.ARTIFACTS.name();
                if (sep == -1) {
                    name = key;
                    state = ExtensionState.OPTIONAL.name();
                } else {
                    name = key.substring(0, sep);
                    state = key.substring(sep + 1);
                }
            } else {
                name = key.substring(0, pos);
                if (sep == -1) {
                    type = postfix;
                    state = ExtensionState.OPTIONAL.name();
                } else {
                    type = postfix.substring(0, sep);
                    state = postfix.substring(sep + 1);
                }
            }
            if (JSONConstants.FEATURE_KNOWN_PROPERTIES.contains(name)) {
                throw new IOException(this.exceptionPrefix + "Extension is using reserved name : " + name);
            }
            if (container.getByName(name) != null) {
                throw new IOException(this.exceptionPrefix + "Duplicate extension with name " + name);
            }
            ExtensionType extType = ExtensionType.valueOf((String)type);
            ExtensionState extState = ExtensionState.OPTIONAL.name().equalsIgnoreCase(state) ? ExtensionState.OPTIONAL : (ExtensionState.REQUIRED.name().equalsIgnoreCase(state) ? ExtensionState.REQUIRED : (ExtensionState.TRANSIENT.name().equalsIgnoreCase(state) ? ExtensionState.TRANSIENT : ((opt = Boolean.valueOf(state).booleanValue()) ? ExtensionState.REQUIRED : ExtensionState.OPTIONAL)));
            Extension ext = new Extension(extType, name, extState);
            Object value = map.get(key);
            switch (extType) {
                case ARTIFACTS: {
                    ArrayList<Artifact> list = new ArrayList<Artifact>();
                    this.readArtifacts("Extension " + name, "artifact", list, value, configContainer);
                    for (Artifact a : list) {
                        if (ext.getArtifacts().contains((Object)a)) {
                            throw new IOException(this.exceptionPrefix + "Duplicate artifact in extension " + name + " : " + a.getId().toMvnId());
                        }
                        ext.getArtifacts().add(a);
                    }
                    break;
                }
                case JSON: {
                    this.checkType("JSON Extension " + name, value, Map.class, List.class);
                    JsonStructure struct = this.build(value);
                    ext.setJSONStructure(struct);
                    break;
                }
                case TEXT: {
                    this.checkType("Text Extension " + name, value, String.class, List.class);
                    if (value instanceof String) {
                        ext.setText(value.toString());
                        break;
                    }
                    List l = (List)value;
                    StringBuilder sb = new StringBuilder();
                    for (Object o : l) {
                        this.checkType("Text Extension " + name + ", value " + o, o, String.class);
                        sb.append(o.toString());
                        sb.append('\n');
                    }
                    ext.setText(sb.toString());
                }
            }
            container.add((Object)ext);
        }
    }

    private JsonStructure build(Object value) {
        if (value instanceof List) {
            List list = (List)value;
            JsonArrayBuilder builder = Json.createArrayBuilder();
            for (Object obj : list) {
                if (obj instanceof String) {
                    builder.add(obj.toString());
                    continue;
                }
                if (obj instanceof Long) {
                    builder.add(((Long)obj).longValue());
                    continue;
                }
                if (obj instanceof Double) {
                    builder.add(((Double)obj).doubleValue());
                    continue;
                }
                if (obj instanceof Boolean) {
                    builder.add(((Boolean)obj).booleanValue());
                    continue;
                }
                if (obj instanceof Map) {
                    builder.add((JsonValue)this.build(obj));
                    continue;
                }
                if (!(obj instanceof List)) continue;
                builder.add((JsonValue)this.build(obj));
            }
            return builder.build();
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            JsonObjectBuilder builder = Json.createObjectBuilder();
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getValue() instanceof String) {
                    builder.add((String)entry.getKey(), entry.getValue().toString());
                    continue;
                }
                if (entry.getValue() instanceof Long) {
                    builder.add((String)entry.getKey(), ((Long)entry.getValue()).longValue());
                    continue;
                }
                if (entry.getValue() instanceof Double) {
                    builder.add((String)entry.getKey(), ((Double)entry.getValue()).doubleValue());
                    continue;
                }
                if (entry.getValue() instanceof Boolean) {
                    builder.add((String)entry.getKey(), ((Boolean)entry.getValue()).booleanValue());
                    continue;
                }
                if (entry.getValue() instanceof Map) {
                    builder.add((String)entry.getKey(), (JsonValue)this.build(entry.getValue()));
                    continue;
                }
                if (!(entry.getValue() instanceof List)) continue;
                builder.add((String)entry.getKey(), (JsonValue)this.build(entry.getValue()));
            }
            return builder.build();
        }
        return null;
    }

    protected void checkType(String key, Object val, Class<?> ... types) throws IOException {
        boolean valid = false;
        for (Class<?> c : types) {
            if (c == null) {
                if (val != null) continue;
                valid = true;
                break;
            }
            if (!c.isInstance(val)) continue;
            valid = true;
            break;
        }
        if (!valid) {
            throw new IOException(this.exceptionPrefix + "Key " + key + " is not one of the allowed types " + Arrays.toString(types) + " : " + val.getClass());
        }
    }

    protected Prototype readPrototype(Map<String, Object> map) throws IOException {
        if (map.containsKey("prototype")) {
            Prototype prototype;
            Object prototypeObj = map.get("prototype");
            this.checkType("prototype", prototypeObj, Map.class, String.class);
            if (prototypeObj instanceof String) {
                ArtifactId id = ArtifactId.parse((String)prototypeObj.toString());
                prototype = new Prototype(id);
            } else {
                Map obj = (Map)prototypeObj;
                if (!obj.containsKey("id")) {
                    throw new IOException(this.exceptionPrefix + " prototype is missing required artifact id");
                }
                this.checkType("Prototype id", obj.get("id"), String.class);
                ArtifactId id = ArtifactId.parse((String)obj.get("id").toString());
                prototype = new Prototype(id);
                if (obj.containsKey("removals")) {
                    List list;
                    this.checkType("Prototype removals", obj.get("removals"), Map.class);
                    Map removalObj = (Map)obj.get("removals");
                    if (removalObj.containsKey("bundles")) {
                        this.checkType("Prototype removal bundles", removalObj.get("bundles"), List.class);
                        list = (List)removalObj.get("bundles");
                        for (Object val : list) {
                            this.checkType("Prototype removal bundles", val, String.class);
                            if (val.toString().startsWith("#")) continue;
                            prototype.getBundleRemovals().add(ArtifactId.parse((String)val.toString()));
                        }
                    }
                    if (removalObj.containsKey("configurations")) {
                        this.checkType("Prototype removal configuration", removalObj.get("configurations"), List.class);
                        list = (List)removalObj.get("configurations");
                        for (Object val : list) {
                            this.checkType("Prototype removal configuration", val, String.class);
                            prototype.getConfigurationRemovals().add(val.toString());
                        }
                    }
                    if (removalObj.containsKey("framework-properties")) {
                        this.checkType("Prototype removal framework properties", removalObj.get("framework-properties"), List.class);
                        list = (List)removalObj.get("framework-properties");
                        for (Object val : list) {
                            this.checkType("Prototype removal framework properties", val, String.class);
                            prototype.getFrameworkPropertiesRemovals().add(val.toString());
                        }
                    }
                    if (removalObj.containsKey("extensions")) {
                        this.checkType("Prototype removal extensions", removalObj.get("extensions"), List.class);
                        list = (List)removalObj.get("extensions");
                        for (Object val : list) {
                            this.checkType("Prototype removal extension", val, String.class, Map.class);
                            if (val instanceof String) {
                                if (val.toString().startsWith("#")) continue;
                                prototype.getExtensionRemovals().add(val.toString());
                                continue;
                            }
                            Map removalMap = (Map)val;
                            Object nameObj = removalMap.get("name");
                            this.checkType("Prototype removal extension", nameObj, String.class);
                            if (removalMap.containsKey("artifacts")) {
                                this.checkType("Prototype removal extension artifacts", removalMap.get("artifacts"), List.class);
                                List artifactList = (List)removalMap.get("artifacts");
                                ArrayList<ArtifactId> ids = new ArrayList<ArtifactId>();
                                for (Object aid : artifactList) {
                                    this.checkType("Prototype removal extension artifact", aid, String.class);
                                    ids.add(ArtifactId.parse((String)aid.toString()));
                                }
                                prototype.getArtifactExtensionRemovals().put(nameObj.toString(), ids);
                                continue;
                            }
                            prototype.getExtensionRemovals().add(nameObj.toString());
                        }
                    }
                    this.readRequirements(removalObj, prototype.getRequirementRemovals());
                    this.readCapabilities(removalObj, prototype.getCapabilityRemovals());
                }
            }
            return prototype;
        }
        return null;
    }

    protected void readRequirements(Map<String, Object> map, List<MatchingRequirement> container) throws IOException {
        if (map.containsKey("requirements")) {
            Object reqObj = map.get("requirements");
            this.checkType("requirements", reqObj, List.class);
            List requirements = (List)reqObj;
            for (Object req : requirements) {
                this.checkType("Requirement", req, Map.class);
                Map obj = (Map)req;
                if (!obj.containsKey("namespace")) {
                    throw new IOException(this.exceptionPrefix + "Namespace is missing for requirement");
                }
                this.checkType("Requirement namespace", obj.get("namespace"), String.class);
                HashMap<String, Object> attrMap = new HashMap<String, Object>();
                if (obj.containsKey("attributes")) {
                    this.checkType("Requirement attributes", obj.get("attributes"), Map.class);
                    Map attrs = (Map)obj.get("attributes");
                    attrs.forEach(JSONReaderBase.rethrowBiConsumer((key, value) -> ManifestUtils.unmarshalAttribute(key, value, attrMap::put)));
                }
                HashMap<String, String> dirMap = new HashMap<String, String>();
                if (obj.containsKey("directives")) {
                    this.checkType("Requirement directives", obj.get("directives"), Map.class);
                    Map dirs = (Map)obj.get("directives");
                    dirs.forEach(JSONReaderBase.rethrowBiConsumer((key, value) -> ManifestUtils.unmarshalDirective(key, value, dirMap::put)));
                }
                MatchingRequirementImpl r = new MatchingRequirementImpl(null, obj.get("namespace").toString(), dirMap, attrMap);
                container.add(r);
            }
        }
    }

    protected void readCapabilities(Map<String, Object> map, List<Capability> container) throws IOException {
        if (map.containsKey("capabilities")) {
            Object capObj = map.get("capabilities");
            this.checkType("capabilities", capObj, List.class);
            List capabilities = (List)capObj;
            for (Object cap : capabilities) {
                this.checkType("Capability", cap, Map.class);
                Map obj = (Map)cap;
                if (!obj.containsKey("namespace")) {
                    throw new IOException(this.exceptionPrefix + "Namespace is missing for capability");
                }
                this.checkType("Capability namespace", obj.get("namespace"), String.class);
                HashMap<String, Object> attrMap = new HashMap<String, Object>();
                if (obj.containsKey("attributes")) {
                    this.checkType("Capability attributes", obj.get("attributes"), Map.class);
                    Map attrs = (Map)obj.get("attributes");
                    attrs.forEach(JSONReaderBase.rethrowBiConsumer((key, value) -> ManifestUtils.unmarshalAttribute(key, value, attrMap::put)));
                }
                HashMap<String, String> dirMap = new HashMap<String, String>();
                if (obj.containsKey("directives")) {
                    this.checkType("Capability directives", obj.get("directives"), Map.class);
                    Map dirs = (Map)obj.get("directives");
                    dirs.forEach(JSONReaderBase.rethrowBiConsumer((key, value) -> ManifestUtils.unmarshalDirective(key, value, dirMap::put)));
                }
                CapabilityImpl c = new CapabilityImpl(null, obj.get("namespace").toString(), dirMap, attrMap);
                container.add(c);
            }
        }
    }

    private static <T, V, E extends Exception> BiConsumer<T, V> rethrowBiConsumer(BiConsumer_WithExceptions<T, V, E> biConsumer) {
        return (t, u) -> {
            try {
                biConsumer.accept(t, u);
            }
            catch (Exception exception) {
                JSONReaderBase.throwAsUnchecked(exception);
            }
        };
    }

    private static <E extends Throwable> void throwAsUnchecked(Exception exception) throws E {
        throw exception;
    }

    private static class MatchingRequirementImpl
    extends RequirementImpl
    implements MatchingRequirement {
        public MatchingRequirementImpl(Resource res, String ns, Map<String, String> dirs, Map<String, Object> attrs) {
            super(res, ns, dirs, attrs);
        }
    }

    @FunctionalInterface
    private static interface BiConsumer_WithExceptions<T, V, E extends Exception> {
        public void accept(T var1, V var2) throws E;
    }
}

