/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hapi.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.hapi.HApiException;
import org.apache.sling.hapi.HApiProperty;
import org.apache.sling.hapi.HApiType;
import org.apache.sling.hapi.MicrodataAttributeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicrodataAttributeHelperImpl
implements MicrodataAttributeHelper {
    private static final Logger LOG = LoggerFactory.getLogger(MicrodataAttributeHelperImpl.class);
    private final ResourceResolver resolver;
    HApiType type;

    public MicrodataAttributeHelperImpl(ResourceResolver resolver, HApiType type) {
        this.resolver = resolver;
        this.type = type;
    }

    @Override
    public String itemtype() {
        return this.itemtypeMap().toString();
    }

    @Override
    public Map<String, String> itemtypeMap() {
        AttrMap attrMap = new AttrMap(2);
        attrMap.put("itemtype", this.type.getUrl());
        attrMap.put("itemscope", "itemscope");
        return attrMap;
    }

    @Override
    public String itemprop(String propName) {
        return this.itemprop(propName, true);
    }

    @Override
    public String itemprop(String propName, boolean withType) {
        return this.itempropMap(propName, withType).toString();
    }

    @Override
    public Map<String, String> itempropMap(String propName, boolean withType) {
        HApiProperty prop = this.type.getAllProperties().get(propName);
        if (null == prop) {
            throw new HApiException("Property " + propName + " does not exist for type " + this.type.getPath());
        }
        AttrMap attrMap = new AttrMap(3);
        attrMap.put("itemprop", propName);
        if (withType) {
            attrMap.putAll(new MicrodataAttributeHelperImpl(this.resolver, prop.getType()).itemtypeMap());
        }
        return attrMap;
    }

    @Override
    public Map<String, Map<String, String>> allItemPropMap() {
        PropMap m = new PropMap(this.type);
        for (String prop : this.type.getAllProperties().keySet()) {
            m.put(prop, this.itempropMap(prop, true));
        }
        return m;
    }

    @Override
    public Map<String, String> allPropTypesMap() {
        Map<String, HApiProperty> props = this.type.getAllProperties();
        HashMap<String, String> types = new HashMap<String, String>(props.size());
        for (String propName : props.keySet()) {
            types.put(propName, props.get(propName).getType().getPath());
        }
        return types;
    }

    private class AttrMap
    extends HashMap<String, String> {
        public AttrMap(int i) {
            super(i);
        }

        public AttrMap() {
        }

        public AttrMap(int initialCapacity, float loadFactor) {
            super(initialCapacity, loadFactor);
        }

        @Override
        public String toString() {
            String norm = "";
            for (Map.Entry entry : this.entrySet()) {
                norm = norm + (String)entry.getKey() + "=\"" + (String)entry.getValue() + "\" ";
            }
            return norm;
        }
    }

    private class PropMap
    extends HashMap<String, Map<String, String>> {
        private final HApiType type;

        public PropMap(HApiType type) {
            this.type = type;
        }

        @Override
        public Map<String, String> get(Object key) {
            Map val = (Map)super.get(key);
            if (null == val) {
                LOG.debug("type = {}", (Object)this.type);
                throw new HApiException("Property " + key + " does not exist for type " + this.type.getPath());
            }
            return val;
        }
    }
}

