/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import org.apache.jackrabbit.core.query.lucene.directory.IndexInputStream;
import org.apache.lucene.store.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IndexingQueueStore {
    private static final Logger log = LoggerFactory.getLogger(IndexingQueueStore.class);
    private static final String ENCODING = "UTF-8";
    private static final String ADD = "ADD";
    private static final String REMOVE = "REMOVE";
    private static final String INDEXING_QUEUE_FILE = "indexing_queue.log";
    private final Set<String> pending = new HashSet<String>();
    private final Directory dir;

    IndexingQueueStore(Directory directory) throws IOException {
        this.dir = directory;
        this.readStore();
    }

    public String[] getPending() {
        return this.pending.toArray(new String[this.pending.size()]);
    }

    public void addUUID(String uuid) {
        this.pending.add(uuid);
    }

    public void removeUUID(String uuid) {
        this.pending.remove(uuid);
    }

    public void close() {
        if (this.pending.isEmpty()) {
            try {
                if (this.dir.fileExists(INDEXING_QUEUE_FILE)) {
                    this.dir.deleteFile(INDEXING_QUEUE_FILE);
                }
            }
            catch (IOException e) {
                log.warn("unable to delete indexing_queue.log");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readStore() throws IOException {
        if (this.dir.fileExists(INDEXING_QUEUE_FILE)) {
            IndexInputStream in = new IndexInputStream(this.dir.openInput(INDEXING_QUEUE_FILE));
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, ENCODING));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    int idx = line.indexOf(32);
                    if (idx == -1) {
                        log.warn("invalid line in {}: {}", (Object)INDEXING_QUEUE_FILE, (Object)line);
                        continue;
                    }
                    String cmd = line.substring(0, idx);
                    String uuid = line.substring(idx + 1, line.length());
                    if (ADD.equals(cmd)) {
                        this.pending.add(uuid);
                        continue;
                    }
                    if (REMOVE.equals(cmd)) {
                        this.pending.remove(uuid);
                        continue;
                    }
                    log.warn("invalid line in {}: {}", (Object)INDEXING_QUEUE_FILE, (Object)line);
                }
            }
            finally {
                ((InputStream)in).close();
            }
        }
    }
}

