/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.impl.servlet.junit5;

import java.lang.reflect.Method;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.core.LauncherConfig;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;

public final class JUnitPlatformHelper {
    public static void executeTest(@NotNull TestEngine testEngine, @NotNull Class<?> testClass, @Nullable String testMethodName, TestExecutionListener ... listeners) {
        Launcher launcher = JUnitPlatformHelper.createLauncher(testEngine);
        LauncherDiscoveryRequest request = testMethodName != null ? JUnitPlatformHelper.methodRequest(testClass, testMethodName) : JUnitPlatformHelper.classesRequest(testClass);
        launcher.execute(request, listeners);
    }

    @NotNull
    public static Launcher createLauncher(TestEngine ... testEngines) {
        return LauncherFactory.create((LauncherConfig)LauncherConfig.builder().enableTestEngineAutoRegistration(false).enableTestExecutionListenerAutoRegistration(false).addTestEngines(testEngines).build());
    }

    @NotNull
    public static LauncherDiscoveryRequest methodRequest(Class<?> testClass, String testMethodName) {
        LauncherDiscoveryRequestBuilder requestBuilder = LauncherDiscoveryRequestBuilder.request();
        ReflectionUtils.findMethods(testClass, method -> Objects.equals(method.getName(), testMethodName)).stream().map(method -> DiscoverySelectors.selectMethod((Class)testClass, (Method)method)).forEach(xva$0 -> requestBuilder.selectors(new DiscoverySelector[]{xva$0}));
        return requestBuilder.build();
    }

    @NotNull
    public static LauncherDiscoveryRequest classesRequest(Class<?> ... testClasses) {
        DiscoverySelector[] selectors = (DiscoverySelector[])Stream.of(testClasses).map(DiscoverySelectors::selectClass).toArray(DiscoverySelector[]::new);
        return LauncherDiscoveryRequestBuilder.request().selectors(selectors).build();
    }

    private JUnitPlatformHelper() {
    }
}

