/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes;

import java.io.IOException;
import java.io.Writer;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.pipes.BasePipe;
import org.apache.sling.pipes.CommandUtil;
import org.apache.sling.pipes.Pipe;
import org.apache.sling.pipes.PipeBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OutputWriter {
    private static final Logger LOG = LoggerFactory.getLogger(OutputWriter.class);
    public static final String KEY_SIZE = "size";
    public static final String KEY_ITEMS = "items";
    public static final String KEY_ERRORS = "errors";
    public static final String KEY_NB_ERRORS = "nbErrors";
    protected static final String NEW_LINE = "\n";
    public static final String PARAM_SIZE = "size";
    public static final int NB_MAX = 10;
    protected boolean autoClose = true;
    protected long size;
    protected long nbErrors;
    protected long max = 10L;
    protected Pipe pipe;
    protected Writer writer;
    public static final String PATH_KEY = "path";
    public static final String PARAM_WRITER = "writer";
    protected Map<String, Object> customOutputs;
    protected List<String> errors = new ArrayList<String>();

    public abstract boolean handleRequest(SlingHttpServletRequest var1);

    public void init(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        String writerParam;
        if (request.getParameter("size") != null) {
            this.setMax(Integer.parseInt(request.getParameter("size")));
        }
        if (StringUtils.isNotBlank((CharSequence)(writerParam = request.getParameter(PARAM_WRITER)))) {
            this.customOutputs = CommandUtil.stringToMap(writerParam, PipeBindings::embedAsScript);
        }
        this.setWriter(response.getWriter());
        this.initResponse(response);
        this.starts();
    }

    public void setCustomOutputs(Map<String, Object> customOutputs) {
        this.customOutputs = customOutputs;
    }

    protected abstract void initResponse(SlingHttpServletResponse var1);

    public abstract void starts();

    public void setMax(int max) {
        this.max = max;
        if (max < 0) {
            this.max = Integer.MAX_VALUE;
        }
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public void write(Resource resource) {
        if (this.size++ < this.max) {
            this.writeItem(resource);
        }
    }

    public void error(String path) {
        if (this.nbErrors++ < this.max) {
            this.errors.add(path);
        }
    }

    protected abstract void writeItem(Resource var1);

    public abstract void ends();

    public boolean autoClose() {
        return this.autoClose;
    }

    public void disableAutoClose() {
        this.autoClose = false;
    }

    public void setPipe(Pipe pipe) {
        this.pipe = pipe;
        Resource outputs = pipe.getResource().getChild(PARAM_WRITER);
        if (this.customOutputs == null && outputs != null) {
            this.customOutputs = new HashMap<String, Object>();
            this.customOutputs.putAll((Map<String, Object>)outputs.getValueMap());
            for (String ignoredKey : BasePipe.IGNORED_PROPERTIES) {
                this.customOutputs.remove(ignoredKey);
            }
        }
    }

    protected String computeValue(String key) {
        String value = "";
        try {
            Object o = this.pipe.getBindings().instantiateObject((String)this.customOutputs.get(key));
            if (o != null) {
                if (o instanceof Calendar) {
                    Instant i = ((Calendar)o).toInstant();
                    value = DateTimeFormatter.ISO_LOCAL_DATE_TIME.withZone(ZoneId.from(ZoneOffset.UTC)).format(i);
                } else {
                    value = o.toString();
                }
            }
        }
        catch (RuntimeException e) {
            LOG.debug("unable to write entry {}, will write empty value", (Object)key, (Object)e);
        }
        return value;
    }

    public String toString() {
        return this.writer.toString();
    }

    public Map<String, Object> getCustomOutputs() {
        return this.customOutputs;
    }
}

