/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourcebuilder.impl;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.resourcebuilder.api.ResourceBuilder;
import org.apache.sling.resourcebuilder.api.ResourceBuilderFactory;
import org.apache.sling.resourcebuilder.impl.ResourceBuilderImpl;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ResourceBuilderFactory.class})
public class ResourceBuilderFactoryService
implements ResourceBuilderFactory {
    @Reference
    private MimeTypeService mimeTypeService;

    @Override
    @NotNull
    public ResourceBuilder forParent(@NotNull Resource parent) {
        return new ResourceBuilderImpl(parent, this.mimeTypeService);
    }

    @Override
    @NotNull
    public ResourceBuilder forResolver(@NotNull ResourceResolver r) {
        Resource root = r.getResource("/");
        if (root == null) {
            throw new IllegalStateException("Cannot read root resource");
        }
        return this.forParent(root);
    }
}

