/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hamcrest.matchers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.hamcrest.matchers.ResourcePathMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.collection.IsIterableContainingInOrder;

public class ResourceCollectionPathMatcher
extends TypeSafeMatcher<Collection<Resource>> {
    private final Matcher<?> iterarableMatcher;

    public ResourceCollectionPathMatcher(List<String> paths) {
        if (paths == null || paths.isEmpty()) {
            throw new IllegalArgumentException("names is null or empty");
        }
        ArrayList<ResourcePathMatcher> resourceMatchers = new ArrayList<ResourcePathMatcher>();
        for (String path : paths) {
            resourceMatchers.add(new ResourcePathMatcher(path));
        }
        this.iterarableMatcher = IsIterableContainingInOrder.contains(resourceMatchers);
    }

    public void describeTo(Description description) {
        this.iterarableMatcher.describeTo(description);
    }

    protected boolean matchesSafely(Collection<Resource> items) {
        return this.iterarableMatcher.matches(items);
    }

    protected void describeMismatchSafely(Collection<Resource> items, Description mismatchDescription) {
        this.iterarableMatcher.describeMismatch(items, mismatchDescription);
    }
}

