/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.tools.junit;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.sling.testing.tools.http.Request;
import org.apache.sling.testing.tools.http.RequestBuilder;
import org.apache.sling.testing.tools.http.RequestExecutor;
import org.apache.sling.testing.tools.sling.SlingInstanceState;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.slf4j.MDC;
import org.slf4j.spi.MDCAdapter;

public class RemoteLogDumper
extends TestWatcher {
    public static final String TEST_CLASS = "X-Sling-Test-Class";
    public static final String TEST_NAME = "X-Sling-Test-Name";
    static final String SERVLET_PATH = "/system/sling/testlog";

    protected void finished(Description description) {
        MDC.remove((String)TEST_CLASS);
        MDC.remove((String)TEST_NAME);
    }

    protected void starting(Description description) {
        MDC.put((String)TEST_CLASS, (String)description.getClassName());
        MDC.put((String)TEST_NAME, (String)description.getMethodName());
    }

    protected void failed(Throwable e, Description description) {
        String baseUrl = RemoteLogDumper.getServerBaseUrl();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        if (baseUrl != null) {
            try {
                RemoteLogDumper.warnIfNopMDCAdapterBeingUsed();
                DefaultHttpClient httpClient = new DefaultHttpClient();
                RequestExecutor executor = new RequestExecutor(httpClient);
                RequestBuilder rb = new RequestBuilder(baseUrl);
                Request r = rb.buildGetRequest(SERVLET_PATH, TEST_CLASS, description.getClassName(), TEST_NAME, description.getMethodName());
                executor.execute(r);
                int statusCode = executor.getResponse().getStatusLine().getStatusCode();
                String msg = e.getMessage();
                if (msg != null) {
                    pw.println(msg);
                }
                if (statusCode == 200) {
                    pw.printf("=============== Logs from server [%s] for [%s]===================%n", baseUrl, description.getMethodName());
                    pw.print(executor.getContent());
                    pw.println("========================================================");
                } else {
                    pw.printf("Not able to fetch logs from [%s%s]. TestLogServer probably not configured %n", baseUrl, SERVLET_PATH);
                }
            }
            catch (Throwable t) {
                System.err.printf("Error occurred while fetching test logs from server [%s] %n", baseUrl);
                t.printStackTrace(System.err);
            }
            System.err.print(sw.toString());
        }
    }

    private static void warnIfNopMDCAdapterBeingUsed() {
        try {
            MDCAdapter adapter = MDC.getMDCAdapter();
            String msg = null;
            if (adapter == null) {
                msg = "No MDC Adapter found.";
            } else if ("org.slf4j.helpers.NOPMDCAdapter".equals(adapter.getClass().getName())) {
                msg = "MDC adapter set to [org.slf4j.helpers.NOPMDCAdapter].";
            }
            if (msg != null) {
                System.err.printf("%s Possibly running with slf4j-simple. Use Logging implementation like Logback to enable proper MDC support so as to make use of RemoteLogDumper feature.%n", msg);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static String getServerBaseUrl() {
        SlingInstanceState testState = SlingInstanceState.getInstance("default");
        String baseUrl = testState.getServerBaseUrl();
        if (testState.isServerReady()) {
            return baseUrl;
        }
        if (baseUrl == null) {
            baseUrl = RemoteLogDumper.removeEndingSlash(System.getProperty("launchpad.http.server.url"));
        }
        if (baseUrl == null) {
            baseUrl = "http://localhost:8888";
        }
        return baseUrl;
    }

    private static String removeEndingSlash(String str) {
        if (str != null && str.endsWith("/")) {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }
}

