/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.validation.impl.postprocessor;

import java.util.List;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.apache.sling.validation.ValidationResult;
import org.apache.sling.validation.ValidationService;
import org.apache.sling.validation.impl.postprocessor.InvalidResourcePostProcessorException;
import org.apache.sling.validation.impl.postprocessor.ValidationPostProcessorConfiguration;
import org.apache.sling.validation.model.ValidationModel;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Designate(ocd=ValidationPostProcessorConfiguration.class)
public class ValidationPostProcessor
implements SlingPostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ValidationPostProcessor.class);
    private ValidationPostProcessorConfiguration configuration;
    @Reference
    protected ValidationService validationService;

    protected void activate(ValidationPostProcessorConfiguration configuration) {
        this.configuration = configuration;
    }

    private boolean enabledForPath(String path) {
        String[] enabledPathPrefixes = this.configuration.enabledForPathPrefix();
        if (enabledPathPrefixes == null) {
            return false;
        }
        for (String enabledPathPrefix : enabledPathPrefixes) {
            if (!path.startsWith(enabledPathPrefix)) continue;
            return true;
        }
        return false;
    }

    public void process(SlingHttpServletRequest request, List<Modification> changes) throws Exception {
        if (this.configuration.disabled()) {
            LOG.debug("ValidationPostProcessor globally disabled!");
            return;
        }
        String path = request.getResource().getPath();
        if (!this.enabledForPath(path)) {
            LOG.debug("ValidationPostProcessor is not enabled for path {}", (Object)path);
            return;
        }
        LOG.debug("ValidationPostProcessor is enabled for path {}", (Object)path);
        Resource newResource = request.getResourceResolver().getResource(request.getResource().getPath());
        if (newResource == null) {
            LOG.debug("Could not find new/modified resource at {} to validate", (Object)request.getResource().getPath());
            return;
        }
        ValidationModel model = this.validationService.getValidationModel(newResource, this.configuration.considerResourceSuperTypes());
        if (model == null) {
            if (this.configuration.failForMissingValidationModels()) {
                throw new IllegalStateException("Could not find validation model for resource type " + newResource.getResourceType());
            }
            LOG.debug("Could not find validation model for resource type {} -> skip validation", (Object)newResource.getResourceType());
            return;
        }
        ValidationResult validationResult = this.validationService.validate(newResource, model);
        if (!validationResult.isValid()) {
            throw new InvalidResourcePostProcessorException(validationResult, request.getResourceBundle(null));
        }
        LOG.debug("Successfully validated modified/created resource at '{}'", (Object)request.getResource().getPath());
    }
}

