/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.sql.runtime;

import org.apache.storm.sql.runtime.ChannelContext;
import org.apache.storm.sql.runtime.ChannelHandler;
import org.apache.storm.tuple.Values;

public class Channels {
    private static final ChannelContext VOID_CTX = new ChannelContext(){

        @Override
        public void emit(Values data) {
        }

        @Override
        public void fireChannelInactive() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void setSource(Object source) {
        }
    };

    public static ChannelContext chain(ChannelContext next, ChannelHandler handler) {
        return new ChannelContextAdapter(next, handler);
    }

    public static ChannelContext voidContext() {
        return VOID_CTX;
    }

    private static class ForwardingChannelContext
    implements ChannelContext {
        private final ChannelContext next;

        public ForwardingChannelContext(ChannelContext next) {
            this.next = next;
        }

        @Override
        public void emit(Values data) {
            this.next.emit(data);
        }

        @Override
        public void fireChannelInactive() {
            this.next.fireChannelInactive();
        }

        @Override
        public void flush() {
            this.next.flush();
        }

        @Override
        public void setSource(Object source) {
            this.next.setSource(source);
        }
    }

    private static class ChannelContextAdapter
    implements ChannelContext {
        private final ChannelHandler handler;
        private final ChannelContext next;

        public ChannelContextAdapter(ChannelContext next, ChannelHandler handler) {
            this.handler = handler;
            this.next = next;
        }

        @Override
        public void emit(Values data) {
            this.handler.dataReceived(this.next, data);
        }

        @Override
        public void fireChannelInactive() {
            this.handler.channelInactive(this.next);
        }

        @Override
        public void flush() {
            this.handler.flush(this.next);
        }

        @Override
        public void setSource(Object source) {
            this.handler.setSource(this.next, source);
            this.next.setSource(source);
        }
    }
}

