/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.shell.tui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.felix.shell.ShellService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class Activator
implements BundleActivator {
    private static final String CHECK_INPUT_PROP = "shell.tui.checkinput";
    private BundleContext m_context = null;
    private volatile ShellTuiRunnable m_runnable = null;
    private volatile Thread m_thread = null;
    private ServiceReference m_shellRef = null;
    private ShellService m_shell = null;
    private volatile boolean m_checkInput = false;
    static /* synthetic */ Class class$org$apache$felix$shell$ShellService;

    public void start(BundleContext context) {
        this.m_context = context;
        String s = context.getProperty(CHECK_INPUT_PROP);
        this.m_checkInput = s == null ? false : Boolean.valueOf(s);
        ServiceListener sl = new ServiceListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serviceChanged(ServiceEvent event) {
                Activator activator = Activator.this;
                synchronized (activator) {
                    if (event.getType() == 1 && Activator.this.m_shellRef == null) {
                        Activator.this.initializeService();
                    } else if (event.getType() == 4 && event.getServiceReference().equals(Activator.this.m_shellRef)) {
                        Activator.this.m_context.ungetService(Activator.this.m_shellRef);
                        Activator.this.m_shellRef = null;
                        Activator.this.m_shell = null;
                        Activator.this.initializeService();
                    }
                }
            }
        };
        try {
            this.m_context.addServiceListener(sl, "(objectClass=" + (class$org$apache$felix$shell$ShellService == null ? (class$org$apache$felix$shell$ShellService = Activator.class$("org.apache.felix.shell.ShellService")) : class$org$apache$felix$shell$ShellService).getName() + ")");
        }
        catch (InvalidSyntaxException ex) {
            System.err.println("ShellTui: Cannot add service listener.");
            System.err.println("ShellTui: " + (Object)((Object)ex));
        }
        this.initializeService();
        this.m_runnable = new ShellTuiRunnable();
        this.m_thread = new Thread((Runnable)this.m_runnable, "Felix Shell TUI");
        this.m_thread.start();
    }

    private synchronized void initializeService() {
        if (this.m_shell == null) {
            this.m_shellRef = this.m_context.getServiceReference((class$org$apache$felix$shell$ShellService == null ? (class$org$apache$felix$shell$ShellService = Activator.class$("org.apache.felix.shell.ShellService")) : class$org$apache$felix$shell$ShellService).getName());
            if (this.m_shellRef != null) {
                this.m_shell = (ShellService)this.m_context.getService(this.m_shellRef);
            }
        }
    }

    public void stop(BundleContext context) {
        if (this.m_runnable != null) {
            this.m_runnable.stop();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ShellTuiRunnable
    implements Runnable {
        private volatile boolean m_stop = false;

        private ShellTuiRunnable() {
        }

        public void stop() {
            this.m_stop = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            String line = null;
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            try {
                boolean needPrompt = true;
                while (!this.m_stop) {
                    int available;
                    if (needPrompt) {
                        System.out.print("-> ");
                        needPrompt = false;
                    }
                    if (Activator.this.m_checkInput && (available = System.in.available()) == 0) {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException ex) {}
                        continue;
                    }
                    line = in.readLine();
                    if (line == null) {
                        System.err.println("ShellTUI: No standard input...exiting.");
                        return;
                    }
                    needPrompt = true;
                    if ((line = line.trim()).length() == 0) continue;
                    Activator activator = Activator.this;
                    synchronized (activator) {
                        if (Activator.this.m_shell == null) {
                            System.out.println("No impl service available.");
                            continue;
                        }
                        try {
                            Activator.this.m_shell.executeCommand(line, System.out, System.err);
                        }
                        catch (Exception ex) {
                            System.err.println("ShellTUI: " + ex);
                            ex.printStackTrace();
                        }
                    }
                }
                return;
            }
            catch (IOException ex) {
                System.err.println("ShellTUI: Unable to read from stdin...exiting.");
            }
        }
    }
}

