/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.sf.jasperreports.engine.JRDatasetParameter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.ReturnValue;
import net.sf.jasperreports.engine.base.JRBaseDatasetRun;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRDesignDatasetRun
extends JRBaseDatasetRun
implements JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String EXCEPTION_MESSAGE_KEY_DUPLICATE_PARAMETER = "design.dataset.run.duplicate.parameter";
    private Map<String, JRDatasetParameter> parametersMap = new HashMap<String, JRDatasetParameter>();
    private List<JRDatasetParameter> parametersList = new ArrayList<JRDatasetParameter>();
    public static final String PROPERTY_CONNECTION_EXPRESSION = "connectionExpression";
    public static final String PROPERTY_DATASET_NAME = "datasetName";
    public static final String PROPERTY_DATA_SOURCE_EXPRESSION = "dataSourceExpression";
    public static final String PROPERTY_PARAMETERS_MAP_EXPRESSION = "parametersMapExpression";
    public static final String PROPERTY_PARAMETERS = "parameters";
    public static final String PROPERTY_RETURN_VALUES = "returnValues";
    private transient JRPropertyChangeSupport eventSupport;

    public JRDesignDatasetRun() {
        this.returnValues = new ArrayList(2);
    }

    public void addParameter(JRDatasetParameter parameter) throws JRException {
        if (this.parametersMap.containsKey(parameter.getName())) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_DUPLICATE_PARAMETER, parameter.getName());
        }
        this.parametersMap.put(parameter.getName(), parameter);
        this.parametersList.add(parameter);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_PARAMETERS, parameter, this.parametersList.size() - 1);
    }

    public JRDatasetParameter removeParameter(String parameterName) {
        JRDatasetParameter param = this.parametersMap.remove(parameterName);
        if (param != null) {
            int idx = this.parametersList.indexOf(param);
            if (idx >= 0) {
                this.parametersList.remove(idx);
            }
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_PARAMETERS, param, idx);
        }
        return param;
    }

    public JRDatasetParameter removeParameter(JRDatasetParameter parameter) {
        return this.removeParameter(parameter.getName());
    }

    public void setConnectionExpression(JRExpression connectionExpression) {
        JRExpression old = this.connectionExpression;
        this.connectionExpression = connectionExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_CONNECTION_EXPRESSION, old, this.connectionExpression);
    }

    @JsonSetter(value="subDataset")
    public void setDatasetName(String datasetName) {
        String old = this.datasetName;
        this.datasetName = datasetName;
        this.getEventSupport().firePropertyChange(PROPERTY_DATASET_NAME, old, this.datasetName);
    }

    public void setDataSourceExpression(JRExpression dataSourceExpression) {
        JRExpression old = this.dataSourceExpression;
        this.dataSourceExpression = dataSourceExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_DATA_SOURCE_EXPRESSION, old, this.dataSourceExpression);
    }

    public void setParametersMapExpression(JRExpression parametersMapExpression) {
        JRExpression old = this.parametersMapExpression;
        this.parametersMapExpression = parametersMapExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_PARAMETERS_MAP_EXPRESSION, old, this.parametersMapExpression);
    }

    @Override
    public JRDatasetParameter[] getParameters() {
        JRDatasetParameter[] params = new JRDatasetParameter[this.parametersList.size()];
        this.parametersList.toArray(params);
        return params;
    }

    @JsonSetter
    private void setParameters(List<JRDatasetParameter> parameters) throws JRException {
        if (parameters != null) {
            for (JRDatasetParameter parameter : parameters) {
                this.addParameter(parameter);
            }
        }
    }

    public void setUUID(UUID uuid) {
        this.uuid = uuid;
    }

    @JsonSetter
    private void setReturnValues(List<ReturnValue> returnValues) throws JRException {
        if (returnValues != null) {
            for (ReturnValue returnValue : returnValues) {
                this.addReturnValue(returnValue);
            }
        }
    }

    public void addReturnValue(ReturnValue returnValue) {
        this.returnValues.add(returnValue);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_RETURN_VALUES, returnValue, this.returnValues.size() - 1);
    }

    @JsonIgnore
    public List<ReturnValue> getReturnValuesList() {
        return this.returnValues;
    }

    public boolean removeReturnValue(ReturnValue returnValue) {
        int idx = this.returnValues.indexOf(returnValue);
        if (idx >= 0) {
            this.returnValues.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_RETURN_VALUES, returnValue, idx);
            return true;
        }
        return false;
    }

    @Override
    public Object clone() {
        JRDesignDatasetRun clone = (JRDesignDatasetRun)super.clone();
        if (this.parametersList != null) {
            clone.parametersList = new ArrayList<JRDatasetParameter>(this.parametersList.size());
            clone.parametersMap = new HashMap<String, JRDatasetParameter>(this.parametersList.size());
            for (int i = 0; i < this.parametersList.size(); ++i) {
                JRDatasetParameter parameter = JRCloneUtils.nullSafeClone(this.parametersList.get(i));
                clone.parametersList.add(parameter);
                clone.parametersMap.put(parameter.getName(), parameter);
            }
        }
        clone.eventSupport = null;
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPropertyChangeSupport getEventSupport() {
        JRDesignDatasetRun jRDesignDatasetRun = this;
        synchronized (jRDesignDatasetRun) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }
}

