/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.evaluators.source;

import java.util.List;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.synapse.commons.evaluators.EvaluatorContext;
import org.apache.synapse.commons.evaluators.EvaluatorException;
import org.apache.synapse.commons.evaluators.source.SourceTextRetriever;
import org.jaxen.JaxenException;

public class SOAPEnvelopeTextRetriever
implements SourceTextRetriever {
    private String source;
    private AXIOMXPath compiledXPath;

    public SOAPEnvelopeTextRetriever(String source) {
        this.source = source;
    }

    @Override
    public String getSourceText(EvaluatorContext context) throws EvaluatorException {
        Object result;
        SOAPEnvelope envelope = context.getMessageContext().getEnvelope();
        try {
            if (this.compiledXPath == null) {
                this.compiledXPath = new AXIOMXPath(this.source);
            }
            result = this.compiledXPath.evaluate((Object)envelope);
        }
        catch (JaxenException e) {
            throw new EvaluatorException("Error while parsing the XPath expression: " + this.source, e);
        }
        if (result instanceof List) {
            List list = (List)result;
            if (list.size() == 1 && list.get(0) == null) {
                return null;
            }
            StringBuffer textValue = new StringBuffer();
            for (Object o : list) {
                if (o instanceof OMText) {
                    textValue.append(((OMText)o).getText());
                    continue;
                }
                if (o instanceof OMElement) {
                    String s = ((OMElement)o).getText();
                    if (s.trim().length() == 0) {
                        s = o.toString();
                    }
                    textValue.append(s);
                    continue;
                }
                if (o instanceof OMDocument) {
                    textValue.append(((OMDocument)o).getOMDocumentElement().toString());
                    continue;
                }
                if (!(o instanceof OMAttribute)) continue;
                textValue.append(((OMAttribute)o).getAttributeValue());
            }
            return textValue.toString();
        }
        return result.toString();
    }

    @Override
    public String getSource() {
        return this.source;
    }
}

