/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.aspects.statistics;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.aspects.statistics.StatisticsCollector;
import org.apache.synapse.config.SynapsePropertiesLoader;

public class StatisticsCleaner {
    private static final Log log = LogFactory.getLog(StatisticsCleaner.class);
    private static final long DEFAULT_CLEAN_INTERVAL = 300000L;
    private static final String CLEAN_INTERVAL = "statistics.clean.interval";
    private static final String CLEAN_ENABLE = "statistics.clean.enable";
    private StatisticsCollector collector;
    private long cleanInterval;
    private long nextTime = -1L;
    private boolean isCleanEnable = true;

    public StatisticsCleaner(StatisticsCollector collector) {
        this.collector = collector;
        this.cleanInterval = Long.parseLong(SynapsePropertiesLoader.getPropertyValue(CLEAN_INTERVAL, String.valueOf(300000L)));
        this.isCleanEnable = Boolean.parseBoolean(SynapsePropertiesLoader.getPropertyValue(CLEAN_ENABLE, String.valueOf(true)));
        if (this.isCleanEnable && log.isDebugEnabled()) {
            log.debug((Object)("Statistics cleaning is will be occured with interval : " + this.cleanInterval / 1000L + " s."));
        }
    }

    public void clean() {
        try {
            if (!this.isCleanEnable) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Statistics cleaning is disabled.");
                }
                return;
            }
            if (this.collector == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"There are no statistics to be cleaned.");
                }
                return;
            }
            long currentTime = System.currentTimeMillis();
            if (this.nextTime == -1L) {
                this.nextTime = currentTime + this.cleanInterval;
            }
            if (this.nextTime <= currentTime) {
                this.collector.clearStatistics();
                this.nextTime = currentTime + this.cleanInterval;
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"There are no expired statistics to be cleaned.");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

