/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.securevault;

import java.security.Key;
import org.apache.synapse.securevault.AsymmetricCipher;
import org.apache.synapse.securevault.BaseCipher;
import org.apache.synapse.securevault.SymmetricCipher;
import org.apache.synapse.securevault.definition.CipherInformation;
import org.apache.synapse.securevault.definition.KeyStoreInformation;
import org.apache.synapse.securevault.keystore.KeyStoreWrapper;

public class CipherFactory {
    public static BaseCipher createCipher(CipherInformation cipherInformation, KeyStoreInformation keystoreInformation) {
        if ("symmetric".equals(cipherInformation.getType())) {
            return new SymmetricCipher(cipherInformation, keystoreInformation);
        }
        return new AsymmetricCipher(cipherInformation, keystoreInformation);
    }

    public static BaseCipher createCipher(CipherInformation cipherInformation, KeyStoreWrapper keyStoreWrapper) {
        if ("symmetric".equals(cipherInformation.getType())) {
            return new SymmetricCipher(cipherInformation, keyStoreWrapper);
        }
        return new AsymmetricCipher(cipherInformation, keyStoreWrapper);
    }

    public static BaseCipher createCipher(CipherInformation cipherInformation, Key key) {
        if ("symmetric".equals(cipherInformation.getType())) {
            return new SymmetricCipher(cipherInformation, key);
        }
        return new AsymmetricCipher(cipherInformation, key);
    }
}

