/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.binding.decoding;

import java.util.List;
import javax.xml.namespace.QName;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.common.binding.decoding.BaseSAMLMessageDecoder;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.RequestAbstractType;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.StatusResponseType;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSAML2MessageDecoder
extends BaseSAMLMessageDecoder {
    private final Logger log = LoggerFactory.getLogger(BaseSAML2MessageDecoder.class);

    public BaseSAML2MessageDecoder() {
    }

    public BaseSAML2MessageDecoder(ParserPool pool) {
        super(pool);
    }

    public void decode(MessageContext messageContext) throws MessageDecodingException, SecurityException {
        super.decode(messageContext);
        this.checkEndpointURI((SAMLMessageContext)messageContext);
    }

    protected void populateMessageContext(SAMLMessageContext messageContext) throws MessageDecodingException {
        this.populateMessageIdIssueInstantIssuer(messageContext);
        this.populateRelyingPartyMetadata(messageContext);
    }

    protected void populateMessageIdIssueInstantIssuer(SAMLMessageContext messageContext) throws MessageDecodingException {
        if (!(messageContext instanceof SAMLMessageContext)) {
            this.log.debug("Invalid message context type, this policy rule only support SAMLMessageContext");
            return;
        }
        SAMLMessageContext samlMsgCtx = messageContext;
        Object samlMsg = samlMsgCtx.getInboundSAMLMessage();
        if (samlMsg == null) {
            this.log.error("Message context did not contain inbound SAML message");
            throw new MessageDecodingException("Message context did not contain inbound SAML message");
        }
        if (samlMsg instanceof RequestAbstractType) {
            this.log.debug("Extracting ID, issuer and issue instant from request");
            this.extractRequestInfo(samlMsgCtx, (RequestAbstractType)samlMsg);
        } else if (samlMsg instanceof StatusResponseType) {
            this.log.debug("Extracting ID, issuer and issue instant from status response");
            this.extractResponseInfo(samlMsgCtx, (StatusResponseType)samlMsg);
        } else {
            throw new MessageDecodingException("SAML 2 message was not a request or a response");
        }
        if (samlMsgCtx.getInboundMessageIssuer() == null) {
            this.log.warn("Issuer could not be extracted from SAML 2 message");
        }
    }

    protected void extractResponseInfo(SAMLMessageContext messageContext, StatusResponseType statusResponse) throws MessageDecodingException {
        List<Assertion> assertions;
        messageContext.setInboundSAMLMessageId(statusResponse.getID());
        messageContext.setInboundSAMLMessageIssueInstant(statusResponse.getIssueInstant());
        String messageIssuer = null;
        if (statusResponse.getIssuer() != null) {
            messageIssuer = this.extractEntityId(statusResponse.getIssuer());
        } else if (statusResponse instanceof Response && (assertions = ((Response)statusResponse).getAssertions()) != null && assertions.size() > 0) {
            this.log.info("Status response message had no issuer, attempting to extract issuer from enclosed Assertion(s)");
            for (Assertion assertion : assertions) {
                if (assertion == null || assertion.getIssuer() == null) continue;
                String assertionIssuer = this.extractEntityId(assertion.getIssuer());
                if (messageIssuer != null && !messageIssuer.equals(assertionIssuer)) {
                    throw new MessageDecodingException("SAML 2 assertions, within response " + statusResponse.getID() + " contain different issuer IDs");
                }
                messageIssuer = assertionIssuer;
            }
        }
        messageContext.setInboundMessageIssuer(messageIssuer);
    }

    protected void extractRequestInfo(SAMLMessageContext messageContext, RequestAbstractType request) throws MessageDecodingException {
        messageContext.setInboundSAMLMessageId(request.getID());
        messageContext.setInboundSAMLMessageIssueInstant(request.getIssueInstant());
        messageContext.setInboundMessageIssuer(this.extractEntityId(request.getIssuer()));
    }

    protected String extractEntityId(Issuer issuer) throws MessageDecodingException {
        if (issuer != null) {
            if (issuer.getFormat() == null || issuer.getFormat().equals("urn:oasis:names:tc:SAML:2.0:nameid-format:entity")) {
                return issuer.getValue();
            }
            throw new MessageDecodingException("SAML 2 Issuer is not of ENTITY format type");
        }
        return null;
    }

    protected void populateRelyingPartyMetadata(SAMLMessageContext messageContext) throws MessageDecodingException {
        MetadataProvider metadataProvider = messageContext.getMetadataProvider();
        try {
            if (metadataProvider != null) {
                List<RoleDescriptor> roles;
                EntityDescriptor relyingPartyMD = metadataProvider.getEntityDescriptor(messageContext.getInboundMessageIssuer());
                messageContext.setPeerEntityMetadata(relyingPartyMD);
                QName relyingPartyRole = messageContext.getPeerEntityRole();
                if (relyingPartyMD != null && relyingPartyRole != null && (roles = relyingPartyMD.getRoleDescriptors(relyingPartyRole, "urn:oasis:names:tc:SAML:1.1:protocol")) != null && roles.size() > 0) {
                    messageContext.setPeerEntityRoleMetadata(roles.get(0));
                }
            }
        }
        catch (MetadataProviderException e) {
            this.log.error("Error retrieving metadata for relying party " + messageContext.getInboundMessageIssuer(), (Throwable)e);
            throw new MessageDecodingException("Error retrieving metadata for relying party " + messageContext.getInboundMessageIssuer(), (Exception)e);
        }
    }

    protected String getIntendedDestinationEndpointURI(SAMLMessageContext samlMsgCtx) throws MessageDecodingException {
        Object samlMessage = samlMsgCtx.getInboundSAMLMessage();
        String messageDestination = null;
        if (samlMessage instanceof RequestAbstractType) {
            RequestAbstractType request = (RequestAbstractType)samlMessage;
            messageDestination = DatatypeHelper.safeTrimOrNullString((String)request.getDestination());
        } else if (samlMessage instanceof StatusResponseType) {
            StatusResponseType response = (StatusResponseType)samlMessage;
            messageDestination = DatatypeHelper.safeTrimOrNullString((String)response.getDestination());
        } else {
            this.log.error("Invalid SAML message type encountered: {}", (Object)samlMessage.getElementQName().toString());
            throw new MessageDecodingException("Invalid SAML message type encountered");
        }
        return messageDestination;
    }
}

