/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.processors.forward;

import java.util.Map;
import java.util.Set;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.core.axis2.Axis2BlockingClient;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.endpoints.AbstractEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.message.processors.forward.ScheduledMessageForwardingProcessor;
import org.apache.synapse.message.store.MessageStore;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;

@DisallowConcurrentExecution
public class ForwardingJob
implements StatefulJob {
    private static final Log log = LogFactory.getLog(ForwardingJob.class);
    private boolean isMaxDeliverAttemptDropEnabled;
    private boolean consumeAllEnabled;
    private int maxDeliverAttempts;
    private int retryInterval;
    private String deactivateSequence;
    private String faultSequence;
    private String replySequence;
    private String[] retryHttpStatusCodes;
    private State jobState;
    private MessageStore messageStore;
    private Axis2BlockingClient sender;
    private ScheduledMessageForwardingProcessor processor;
    private String targetEndpoint = null;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        JobDataMap jdm = jobExecutionContext.getMergedJobDataMap();
        this.configureForwardingJob(jdm);
        if (!this.processor.isActive() || this.messageStore == null) {
            return;
        }
        this.startProcessingMsgs();
    }

    private void configureForwardingJob(JobDataMap jdm) {
        this.messageStore = (MessageStore)jdm.get((Object)"message.store");
        this.sender = (Axis2BlockingClient)jdm.get((Object)"blocking.sender");
        this.processor = (ScheduledMessageForwardingProcessor)jdm.get((Object)"processor.instance");
        this.retryInterval = 1000;
        this.setParameters(jdm);
    }

    private void setParameters(JobDataMap jdm) {
        Map parameters = (Map)jdm.get((Object)"parameters");
        if (parameters != null) {
            this.maxDeliverAttempts = this.extractMaxDeliveryAttempts(parameters, this.processor);
            this.isMaxDeliverAttemptDropEnabled = this.isMaxDeliverAttemptDropEnabled(parameters);
            this.consumeAllEnabled = this.isConsumeAllEnabled(parameters);
            this.setRetryInterval(parameters);
            if (parameters.get("retry.http.status.codes") != null) {
                this.retryHttpStatusCodes = parameters.get("retry.http.status.codes").toString().split(",");
            }
            this.setSequences(parameters);
            if (jdm.get((Object)"target.endpoint") != null) {
                this.targetEndpoint = (String)jdm.get((Object)"target.endpoint");
            }
        }
    }

    private boolean isConsumeAllEnabled(Map<String, Object> parameters) {
        boolean isConsumeAllEnabled = true;
        if (parameters.get("consume.all") != null && parameters.get("consume.all").toString().equalsIgnoreCase("false")) {
            isConsumeAllEnabled = false;
        }
        return isConsumeAllEnabled;
    }

    private void setRetryInterval(Map<String, Object> parameters) {
        if (parameters.get("retry.interval") != null) {
            try {
                this.retryInterval = Integer.parseInt((String)parameters.get("retry.interval"));
            }
            catch (NumberFormatException nfe) {
                parameters.remove("retry.interval");
                log.error((Object)"Invalid value for retry.interval switching back to default value", (Throwable)nfe);
            }
        }
    }

    private int extractMaxDeliveryAttempts(Map<String, Object> parameters, ScheduledMessageForwardingProcessor processor) {
        int maxDeliverAttempts = -1;
        String mdaParam = (String)parameters.get("max.deliver.attempts");
        if (mdaParam != null && (maxDeliverAttempts = Integer.parseInt(mdaParam)) == 0) {
            processor.deactivate();
        }
        return maxDeliverAttempts;
    }

    private boolean isMaxDeliverAttemptDropEnabled(Map<String, Object> parameters) {
        boolean isMaxDeliverAttemptDropEnabled = false;
        if (this.maxDeliverAttempts > 0 && parameters.get("max.deliver.drop") != null && parameters.get("max.deliver.drop").toString().equalsIgnoreCase("true")) {
            isMaxDeliverAttemptDropEnabled = true;
        }
        return isMaxDeliverAttemptDropEnabled;
    }

    private void setSequences(Map<String, Object> parameters) {
        if (parameters != null) {
            if (parameters.get("message.processor.fault.sequence") != null) {
                this.faultSequence = (String)parameters.get("message.processor.fault.sequence");
            }
            if (parameters.get("message.processor.deactivate.sequence") != null) {
                this.deactivateSequence = (String)parameters.get("message.processor.deactivate.sequence");
            }
            if (parameters.get("message.processor.reply.sequence") != null) {
                this.replySequence = (String)parameters.get("message.processor.reply.sequence");
            }
        }
    }

    private void startProcessingMsgs() {
        do {
            this.jobState = State.CONTINUE_PROCESSING;
            MessageContext inMsgCtx = this.messageStore.peek();
            if (inMsgCtx != null) {
                if (this.isMsgRelatedToThisServer(inMsgCtx)) {
                    this.handleNewMessage(inMsgCtx);
                }
                if (this.jobState == State.CONTINUE_PROCESSING && !this.consumeAllEnabled) {
                    this.jobState = State.STOP_PROCESSING;
                }
            } else {
                this.jobState = State.STOP_PROCESSING;
            }
            this.waitBeforeRetry();
        } while (this.jobState == State.CONTINUE_PROCESSING || this.jobState == State.CONTINUE_RETRYING);
    }

    private void waitBeforeRetry() {
        if (this.jobState == State.CONTINUE_RETRYING) {
            try {
                Thread.sleep(this.retryInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private boolean isMsgRelatedToThisServer(MessageContext inMsgCtx) {
        String serverName = (String)inMsgCtx.getProperty("SynapseConfig.ServerName");
        if (serverName != null && inMsgCtx instanceof Axis2MessageContext) {
            AxisConfiguration configuration = ((Axis2MessageContext)inMsgCtx).getAxis2MessageContext().getConfigurationContext().getAxisConfiguration();
            String myServerName = ForwardingJob.getAxis2ParameterValue(configuration, "SynapseConfig.ServerName");
            return serverName.equals(myServerName);
        }
        return true;
    }

    private static String getAxis2ParameterValue(AxisConfiguration axisConfiguration, String paramKey) {
        Parameter parameter = axisConfiguration.getParameter(paramKey);
        if (parameter == null) {
            return null;
        }
        Object value = parameter.getValue();
        if (value != null && value instanceof String) {
            return (String)parameter.getValue();
        }
        return null;
    }

    private void handleNewMessage(MessageContext inMsgCtx) {
        this.sanitizeMsgContext(inMsgCtx);
        if (this.targetEndpoint == null) {
            this.targetEndpoint = (String)inMsgCtx.getProperty("target.endpoint");
        }
        if (this.targetEndpoint != null) {
            Endpoint ep = inMsgCtx.getEndpoint(this.targetEndpoint);
            if (ep.getContext().readyToSend()) {
                if (ep != null && ((AbstractEndpoint)ep).isLeafEndpoint()) {
                    this.sendMsgToEndpoint(inMsgCtx, ep);
                } else {
                    this.logMsg(this.targetEndpoint, ep);
                    this.messageStore.poll();
                }
            }
        } else {
            log.warn((Object)"Property target.endpoint not found in the message context , Hence removing the message ");
            this.messageStore.poll();
        }
    }

    private void sanitizeMsgContext(MessageContext messageContext) {
        Set proSet = messageContext.getPropertyKeySet();
        if (proSet != null && proSet.contains("blocking.client.error")) {
            proSet.remove("blocking.client.error");
        }
    }

    private void logMsg(String targetEp, Endpoint ep) {
        String logMsg = ep == null ? "Endpoint named " + targetEp + " not found.Hence removing the message form store" : "Unsupported endpoint type. Only address/wsdl/default endpoint types supported";
        log.warn((Object)logMsg);
    }

    private void sendMsgToEndpoint(MessageContext inMsgCtx, Endpoint ep) {
        try {
            MessageContext outCtx = this.sender.send(ep, inMsgCtx);
            if (outCtx != null) {
                this.handleResponse(inMsgCtx, outCtx);
            } else {
                this.messageStore.poll();
                this.processor.resetSentAttemptCount();
            }
        }
        catch (Exception e) {
            this.handleOutOnlyError(inMsgCtx);
            log.error((Object)"Error Forwarding Message ", (Throwable)e);
        }
    }

    private void handleResponse(MessageContext inMsgCtx, MessageContext outCtx) {
        this.handle400and500statusCodes(outCtx);
        if ("true".equals(outCtx.getProperty("blocking.client.error"))) {
            this.handleError(inMsgCtx, outCtx);
        } else {
            this.doPostSuccessTasks(outCtx);
        }
    }

    private void handle400and500statusCodes(MessageContext outCtx) {
        if (outCtx.getProperty("HTTP_SC") != null) {
            String httpStatusCode = outCtx.getProperty("HTTP_SC").toString();
            if (httpStatusCode.equals("500")) {
                outCtx.setProperty("blocking.client.error", "true");
                outCtx.setProperty("ERROR_MESSAGE", "500");
            } else if (httpStatusCode.equals("400")) {
                outCtx.setProperty("blocking.client.error", "true");
                outCtx.setProperty("ERROR_MESSAGE", "400");
            }
        }
    }

    private void handleError(MessageContext inMsgCtx, MessageContext outCtx) {
        if (this.isHttpStatusCodeError(outCtx)) {
            if (this.isRetryHttpStatusCode(outCtx)) {
                this.doPostErrorTasks(inMsgCtx, outCtx);
            } else {
                this.doPostSuccessTasks(outCtx);
            }
        } else {
            this.doPostErrorTasks(inMsgCtx, outCtx);
        }
    }

    private void doPostSuccessTasks(MessageContext outCtx) {
        this.messageStore.poll();
        this.processor.resetSentAttemptCount();
        this.sendResponseToReplySeq(outCtx);
    }

    private void doPostErrorTasks(MessageContext inMsgCtx, MessageContext outCtx) {
        if (this.maxDeliverAttempts > 0) {
            this.processor.incrementSendAttemptCount();
        }
        this.sendItToFaultSequence(outCtx);
        if (this.maxDeliverAttempts > 0) {
            this.handleMaxDeliveryAttempts(inMsgCtx);
        }
    }

    private void handleMaxDeliveryAttempts(MessageContext inMsgCtx) {
        if (this.processor.getSendAttemptCount() >= this.maxDeliverAttempts) {
            if (this.isMaxDeliverAttemptDropEnabled) {
                this.processor.resetSentAttemptCount();
                this.messageStore.poll();
            } else {
                this.deactivate(this.processor, inMsgCtx);
            }
        } else {
            this.jobState = State.CONTINUE_RETRYING;
        }
    }

    private void handleOutOnlyError(MessageContext inMsgCtx) {
        this.sendItToFaultSequence(inMsgCtx);
        if (this.maxDeliverAttempts > 0) {
            this.processor.incrementSendAttemptCount();
            this.handleMaxDeliveryAttempts(inMsgCtx);
        }
    }

    private void sendResponseToReplySeq(MessageContext outCtx) {
        if (this.replySequence != null) {
            Mediator mediator = outCtx.getSequence(this.replySequence);
            if (mediator != null) {
                mediator.mediate(outCtx);
            } else {
                log.warn((Object)("Can't Send the Out Message , Sequence " + this.replySequence + " Does not Exist"));
            }
        }
    }

    private void sendItToFaultSequence(MessageContext outCtx) {
        if (this.faultSequence != null) {
            Mediator mediator = outCtx.getSequence(this.faultSequence);
            if (mediator != null) {
                mediator.mediate(outCtx);
            } else {
                log.warn((Object)("Can't Send the fault Message , Sequence " + this.faultSequence + " Does not Exist"));
            }
        }
    }

    private boolean isHttpStatusCodeError(MessageContext outCtx) {
        if (outCtx.getProperty("ERROR_MESSAGE") != null) {
            String errorMsg = outCtx.getProperty("ERROR_MESSAGE").toString();
            return errorMsg.matches(".*[3-5]\\d\\d.*");
        }
        return false;
    }

    private boolean isRetryHttpStatusCode(MessageContext outCtx) {
        String errorMsg = outCtx.getProperty("ERROR_MESSAGE").toString();
        if (this.retryHttpStatusCodes == null) {
            return false;
        }
        for (String statsCode : this.retryHttpStatusCodes) {
            if (!errorMsg.contains(statsCode)) continue;
            return true;
        }
        return false;
    }

    private void deactivate(ScheduledMessageForwardingProcessor processor, MessageContext inMsgCtx) {
        this.jobState = State.STOP_PROCESSING;
        processor.deactivate();
        if (this.deactivateSequence != null && inMsgCtx != null) {
            this.sendMsgToDeactivateSeq(inMsgCtx);
        }
    }

    private void sendMsgToDeactivateSeq(MessageContext inMsgCtx) {
        Mediator mediator = inMsgCtx.getSequence(this.deactivateSequence);
        if (mediator != null) {
            mediator.mediate(inMsgCtx);
        } else {
            log.warn((Object)("Deactivate sequence: " + this.deactivateSequence + " does not exist"));
        }
    }

    static enum State {
        CONTINUE_PROCESSING,
        CONTINUE_RETRYING,
        STOP_PROCESSING;

    }
}

