/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util.xpath;

import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;
import org.jaxen.function.StringFunction;

public class Base64DecodeFunction
implements Function {
    private static final Log log = LogFactory.getLog(Base64DecodeFunction.class);

    public Object call(Context context, List args) throws FunctionCallException {
        if (args == null || args.size() == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Property key value for lookup is not specified");
            }
            return "";
        }
        int size = args.size();
        if (size == 1) {
            String encodedValue = StringFunction.evaluate(args.get(0), (Navigator)context.getNavigator());
            return this.decode(log.isDebugEnabled(), "UTF-8", encodedValue);
        }
        if (size == 2) {
            String encodedValue = StringFunction.evaluate(args.get(0), (Navigator)context.getNavigator());
            String charset = StringFunction.evaluate(args.get(1), (Navigator)context.getNavigator());
            return this.decode(log.isDebugEnabled(), charset, encodedValue);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"base64Decode function expects only two arguments maximum, returning empty string");
        }
        return "";
    }

    private Object decode(boolean debugOn, String charset, String value) throws FunctionCallException {
        String decodedString;
        if (value == null || value.isEmpty()) {
            if (debugOn) {
                log.debug((Object)"Non empty string value should be provided for decode");
            }
            return "";
        }
        byte[] decodedValue = new Base64().decode(value);
        try {
            decodedString = new String(decodedValue, charset).trim();
        }
        catch (UnsupportedEncodingException e) {
            String msg = "Unsupported Charset";
            log.error((Object)msg, (Throwable)e);
            throw new FunctionCallException(msg, (Exception)e);
        }
        if (debugOn) {
            log.debug((Object)("Decoded base64 encoded value: " + value + " with charset: " + charset + " to String: " + decodedString));
        }
        return decodedString;
    }
}

