/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.sysml.runtime.matrix.data.IJV;
import org.apache.sysml.runtime.matrix.data.SparseRow;

public abstract class SparseBlock
implements Serializable {
    private static final long serialVersionUID = -5008747088111141395L;
    protected static final int INIT_CAPACITY = 4;
    protected static final double RESIZE_FACTOR1 = 2.0;
    protected static final double RESIZE_FACTOR2 = 1.1;

    public abstract void allocate(int var1);

    public abstract void allocate(int var1, int var2);

    public abstract void allocate(int var1, int var2, int var3);

    public abstract void compact(int var1);

    public abstract int numRows();

    public abstract boolean isThreadSafe();

    public abstract boolean isContiguous();

    public boolean isAligned(SparseBlock that) {
        if (this.numRows() != that.numRows()) {
            return false;
        }
        int rlen = this.numRows();
        for (int i = 0; i < rlen; ++i) {
            if (this.isAligned(i, that)) continue;
            return false;
        }
        return true;
    }

    public boolean isAligned(int r, SparseBlock that) {
        if (this.size(r) != that.size(r) || this.pos(r) != that.pos(r)) {
            return false;
        }
        if (!this.isEmpty(r)) {
            int alen = this.size(r);
            int apos = this.pos(r);
            int[] aix = this.indexes(r);
            int[] bix = that.indexes(r);
            for (int j = apos; j < apos + alen; ++j) {
                if (aix[j] == bix[j]) continue;
                return false;
            }
        }
        return true;
    }

    public abstract boolean isAllocated(int var1);

    public abstract void reset();

    public abstract void reset(int var1, int var2);

    public abstract void reset(int var1, int var2, int var3);

    public abstract long size();

    public abstract int size(int var1);

    public abstract long size(int var1, int var2);

    public abstract long size(int var1, int var2, int var3, int var4);

    public abstract boolean isEmpty(int var1);

    public abstract boolean checkValidity(int var1, int var2, long var3, boolean var5);

    public abstract int[] indexes(int var1);

    public abstract double[] values(int var1);

    public abstract int pos(int var1);

    public abstract boolean set(int var1, int var2, double var3);

    public abstract void set(int var1, SparseRow var2, boolean var3);

    public abstract boolean add(int var1, int var2, double var3);

    public abstract void append(int var1, int var2, double var3);

    public abstract void setIndexRange(int var1, int var2, int var3, double[] var4, int var5, int var6);

    public abstract void setIndexRange(int var1, int var2, int var3, double[] var4, int[] var5, int var6, int var7);

    public abstract void deleteIndexRange(int var1, int var2, int var3);

    public abstract void sort();

    public abstract void sort(int var1);

    public abstract double get(int var1, int var2);

    public abstract SparseRow get(int var1);

    public abstract int posFIndexLTE(int var1, int var2);

    public abstract int posFIndexGTE(int var1, int var2);

    public abstract int posFIndexGT(int var1, int var2);

    public Iterator<IJV> getIterator() {
        return new SparseBlockIterator(this.numRows());
    }

    public Iterator<IJV> getIterator(int ru) {
        return new SparseBlockIterator(ru);
    }

    public Iterator<IJV> getIterator(int rl, int ru) {
        return new SparseBlockIterator(rl, Math.min(ru, this.numRows()));
    }

    public abstract String toString();

    private class SparseBlockIterator
    implements Iterator<IJV> {
        private int _rlen = 0;
        private int _curRow = -1;
        private int _curColIx = -1;
        private int[] _curIndexes = null;
        private double[] _curValues = null;
        private boolean _noNext = false;
        private IJV retijv = new IJV();

        protected SparseBlockIterator(int ru) {
            this._rlen = ru;
            this._curRow = 0;
            this.findNextNonZeroRow();
        }

        protected SparseBlockIterator(int rl, int ru) {
            this._rlen = ru;
            this._curRow = rl;
            this.findNextNonZeroRow();
        }

        @Override
        public boolean hasNext() {
            return !this._noNext;
        }

        @Override
        public IJV next() {
            this.retijv.set(this._curRow, this._curIndexes[this._curColIx], this._curValues[this._curColIx]);
            if (this._curColIx < SparseBlock.this.pos(this._curRow) + SparseBlock.this.size(this._curRow) - 1) {
                ++this._curColIx;
            } else {
                ++this._curRow;
                this.findNextNonZeroRow();
            }
            return this.retijv;
        }

        @Override
        public void remove() {
            throw new RuntimeException("SparseBlockIterator is unsupported!");
        }

        private void findNextNonZeroRow() {
            while (this._curRow < this._rlen && SparseBlock.this.isEmpty(this._curRow)) {
                ++this._curRow;
            }
            if (this._curRow >= this._rlen) {
                this._noNext = true;
            } else {
                this._curColIx = SparseBlock.this.pos(this._curRow);
                this._curIndexes = SparseBlock.this.indexes(this._curRow);
                this._curValues = SparseBlock.this.values(this._curRow);
            }
        }
    }

    public static enum Type {
        MCSR,
        CSR,
        COO;

    }
}

