/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.spark;

import java.util.HashSet;
import java.util.Set;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.recompile.Recompiler;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.caching.FrameObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.spark.SPInstruction;
import org.apache.sysds.runtime.instructions.spark.UnarySPInstruction;
import org.apache.sysds.runtime.instructions.spark.utils.FrameRDDConverterUtils;
import org.apache.sysds.runtime.instructions.spark.utils.RDDConverterUtils;
import org.apache.sysds.runtime.matrix.data.FrameBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MetaDataFormat;
import org.apache.sysds.utils.Statistics;

public class CSVReblockSPInstruction
extends UnarySPInstruction {
    private int _blen;
    private boolean _hasHeader;
    private String _delim;
    private boolean _fill;
    private double _fillValue;
    private Set<String> _naStrings;

    protected CSVReblockSPInstruction(Operator op, CPOperand in, CPOperand out, int br, int bc, boolean hasHeader, String delim, boolean fill, double fillValue, String opcode, String instr, Set<String> naStrings) {
        super(SPInstruction.SPType.CSVReblock, op, in, out, opcode, instr);
        this._blen = br;
        this._blen = bc;
        this._hasHeader = hasHeader;
        this._delim = delim;
        this._fill = fill;
        this._fillValue = fillValue;
        this._naStrings = naStrings;
    }

    public static CSVReblockSPInstruction parseInstruction(String str) {
        String opcode = InstructionUtils.getOpCode(str);
        if (!opcode.equals("csvrblk")) {
            throw new DMLRuntimeException("Incorrect opcode for CSVReblockSPInstruction:" + opcode);
        }
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        CPOperand in = new CPOperand(parts[1]);
        CPOperand out = new CPOperand(parts[2]);
        int blen = Integer.parseInt(parts[3]);
        boolean hasHeader = Boolean.parseBoolean(parts[4]);
        String delim = parts[5];
        boolean fill = Boolean.parseBoolean(parts[6]);
        double fillValue = Double.parseDouble(parts[7]);
        HashSet<String> naStrings = null;
        String[] naS = parts[8].split("\u00b7");
        if (!(naS.length <= 0 || naS.length == 1 && naS[0].isEmpty())) {
            naStrings = new HashSet<String>();
            for (String s : naS) {
                naStrings.add(s);
            }
        }
        return new CSVReblockSPInstruction(null, in, out, blen, blen, hasHeader, delim, fill, fillValue, opcode, str, naStrings);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        CacheableData<?> obj = sec.getCacheableData(this.input1.getName());
        MetaDataFormat iimd = (MetaDataFormat)obj.getMetaData();
        if (iimd.getFileFormat() != Types.FileFormat.CSV) {
            throw new DMLRuntimeException("The given format is not implemented for CSVReblockSPInstruction:" + iimd.getFileFormat().toString());
        }
        DataCharacteristics mcIn = sec.getDataCharacteristics(this.input1.getName());
        DataCharacteristics mcOut = sec.getDataCharacteristics(this.output.getName());
        mcOut.set(mcIn.getRows(), mcIn.getCols(), this._blen);
        if (Recompiler.checkCPReblock(sec, this.input1.getName())) {
            if (this.input1.getDataType().isMatrix() || this.input1.getDataType().isFrame()) {
                Recompiler.executeInMemoryReblock(sec, this.input1.getName(), this.output.getName());
            }
            Statistics.decrementNoOfExecutedSPInst();
            return;
        }
        Object out = null;
        if (this.input1.getDataType() == Types.DataType.MATRIX) {
            out = this.processMatrixCSVReblockInstruction(sec, mcOut);
        } else if (this.input1.getDataType() == Types.DataType.FRAME) {
            out = this.processFrameCSVReblockInstruction(sec, mcOut, ((FrameObject)obj).getSchema());
        }
        sec.setRDDHandleForVariable(this.output.getName(), (JavaPairRDD<?, ?>)out);
        sec.addLineageRDD(this.output.getName(), this.input1.getName());
    }

    protected JavaPairRDD<MatrixIndexes, MatrixBlock> processMatrixCSVReblockInstruction(SparkExecutionContext sec, DataCharacteristics mcOut) {
        JavaPairRDD<?, ?> in = sec.getRDDHandleForMatrixObject(sec.getMatrixObject(this.input1), Types.FileFormat.CSV);
        return RDDConverterUtils.csvToBinaryBlock(sec.getSparkContext(), in, mcOut, this._hasHeader, this._delim, this._fill, this._fillValue, this._naStrings);
    }

    protected JavaPairRDD<Long, FrameBlock> processFrameCSVReblockInstruction(SparkExecutionContext sec, DataCharacteristics mcOut, Types.ValueType[] schema) {
        JavaPairRDD<?, ?> in = sec.getRDDHandleForFrameObject(sec.getFrameObject(this.input1), Types.FileFormat.CSV);
        return FrameRDDConverterUtils.csvToBinaryBlock(sec.getSparkContext(), in, mcOut, schema, this._hasHeader, this._delim, this._fill, this._fillValue, this._naStrings);
    }
}

