/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupConst;
import org.apache.sysds.runtime.compress.colgroup.ColGroupDDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupEmpty;
import org.apache.sysds.runtime.compress.colgroup.ColGroupOLE;
import org.apache.sysds.runtime.compress.colgroup.ColGroupRLE;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCSingle;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCSingleZeros;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCZeros;
import org.apache.sysds.runtime.compress.colgroup.ColGroupUncompressed;

public class ColGroupIO {
    protected static final Log LOG = LogFactory.getLog((String)ColGroupIO.class.getName());

    public static List<AColGroup> readGroups(DataInput in, int nRows) throws IOException {
        int nColGroups = in.readInt();
        LOG.debug((Object)("reading " + nColGroups + " ColGroups"));
        ArrayList<AColGroup> _colGroups = new ArrayList<AColGroup>(nColGroups);
        for (int i = 0; i < nColGroups; ++i) {
            AColGroup.ColGroupType ctype = AColGroup.ColGroupType.values()[in.readByte()];
            LOG.debug((Object)ctype);
            AColGroup grp = null;
            switch (ctype) {
                case UNCOMPRESSED: {
                    grp = new ColGroupUncompressed();
                    break;
                }
                case OLE: {
                    grp = new ColGroupOLE(nRows);
                    break;
                }
                case RLE: {
                    grp = new ColGroupRLE(nRows);
                    break;
                }
                case DDC: {
                    grp = new ColGroupDDC(nRows);
                    break;
                }
                case CONST: {
                    grp = new ColGroupConst(nRows);
                    break;
                }
                case EMPTY: {
                    grp = new ColGroupEmpty(nRows);
                    break;
                }
                case SDC: {
                    grp = new ColGroupSDC(nRows);
                    break;
                }
                case SDCSingle: {
                    grp = new ColGroupSDCSingle(nRows);
                    break;
                }
                case SDCSingleZeros: {
                    grp = new ColGroupSDCSingleZeros(nRows);
                    break;
                }
                case SDCZeros: {
                    grp = new ColGroupSDCZeros(nRows);
                    break;
                }
                default: {
                    throw new DMLRuntimeException("Unsupported ColGroup Type used:  " + (Object)((Object)ctype));
                }
            }
            grp.readFields(in);
            _colGroups.add(grp);
        }
        return _colGroups;
    }

    public static void writeGroups(DataOutput out, List<AColGroup> colGroups) throws IOException {
        out.writeInt(colGroups.size());
        for (AColGroup grp : colGroups) {
            out.writeByte(grp.getColGroupType().ordinal());
            grp.write(out);
        }
    }

    public static long getExactSizeOnDisk(List<AColGroup> colGroups) {
        long ret = 4L;
        for (AColGroup grp : colGroups) {
            ++ret;
            ret += grp.getExactSizeOnDisk();
        }
        return ret;
    }
}

