/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim;

import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.estim.CompressedSizeEstimator;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;
import org.apache.sysds.runtime.compress.estim.EstimationFactors;
import org.apache.sysds.runtime.compress.lib.BitmapEncoder;
import org.apache.sysds.runtime.compress.utils.ABitmap;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class CompressedSizeEstimatorExact
extends CompressedSizeEstimator {
    public CompressedSizeEstimatorExact(MatrixBlock data, CompressionSettings compSettings) {
        super(data, compSettings);
    }

    @Override
    public CompressedSizeInfoColGroup estimateCompressedColGroupSize(int[] colIndexes, int nrUniqueUpperBound) {
        ABitmap entireBitMap = BitmapEncoder.extractBitmap(colIndexes, this._data, this._transposed);
        EstimationFactors em = this.estimateCompressedColGroupSize(entireBitMap, colIndexes);
        return new CompressedSizeInfoColGroup(em, this._cs.validCompressions, entireBitMap);
    }

    @Override
    public CompressedSizeInfoColGroup estimateJoinCompressedSize(int[] joined, CompressedSizeInfoColGroup g1, CompressedSizeInfoColGroup g2) {
        AMapToData map = MapToFactory.join(g1.getMap(), g2.getMap());
        EstimationFactors em = EstimationFactors.computeSizeEstimation(joined, map, this._cs.validCompressions.contains((Object)AColGroup.CompressionType.RLE), this._numRows, false);
        return new CompressedSizeInfoColGroup(em, this._cs.validCompressions, map);
    }
}

