/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops.rewrite;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.concurrent.Future;
import javax.net.ssl.SSLException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.sysds.api.DMLException;
import org.apache.sysds.hops.Hop;
import org.apache.sysds.hops.LiteralOp;
import org.apache.sysds.hops.rewrite.HopRewriteRule;
import org.apache.sysds.hops.rewrite.ProgramRewriteStatus;
import org.apache.sysds.parser.DataExpression;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedData;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.apache.sysds.runtime.controlprogram.federated.FederatedUDF;
import org.apache.sysds.runtime.controlprogram.federated.FederatedWorkerHandlerException;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.fed.InitFEDInstruction;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.privacy.DMLPrivacyException;
import org.apache.sysds.runtime.privacy.PrivacyConstraint;
import org.apache.sysds.runtime.privacy.propagation.PrivacyPropagator;
import org.apache.sysds.utils.JSONHelper;
import org.apache.wink.json4j.JSONObject;

public class RewriteFederatedExecution
extends HopRewriteRule {
    @Override
    public ArrayList<Hop> rewriteHopDAGs(ArrayList<Hop> roots, ProgramRewriteStatus state) {
        if (roots == null) {
            return null;
        }
        for (Hop root : roots) {
            this.visitHop(root);
        }
        return roots;
    }

    @Override
    public Hop rewriteHopDAG(Hop root, ProgramRewriteStatus state) {
        return null;
    }

    private void visitHop(Hop hop) {
        if (hop.isVisited()) {
            return;
        }
        for (Hop input : hop.getInput()) {
            this.visitHop(input);
        }
        RewriteFederatedExecution.privacyBasedHopDecisionWithFedCall(hop);
        hop.setVisited();
    }

    private static void privacyBasedHopDecisionWithFedCall(Hop hop) {
        RewriteFederatedExecution.loadFederatedPrivacyConstraints(hop);
        PrivacyPropagator.hopPropagation(hop);
    }

    private static void loadFederatedPrivacyConstraints(Hop hop) {
        if (hop.isFederatedDataOp() && hop.getPrivacy() == null) {
            try {
                PrivacyConstraint privConstraint = RewriteFederatedExecution.unwrapPrivConstraint(RewriteFederatedExecution.sendPrivConstraintRequest(hop));
                hop.setPrivacy(privConstraint);
            }
            catch (Exception e) {
                throw new DMLException(e.getMessage());
            }
        }
    }

    private static Future<FederatedResponse> sendPrivConstraintRequest(Hop hop) throws UnknownHostException, SSLException {
        String address = ((LiteralOp)hop.getInput(0).getInput(0)).getStringValue();
        String[] parsedAddress = InitFEDInstruction.parseURL(address);
        String host = parsedAddress[0];
        int port = Integer.parseInt(parsedAddress[1]);
        PrivacyConstraintRetriever retriever = new PrivacyConstraintRetriever(parsedAddress[2]);
        FederatedRequest privacyRetrieval = new FederatedRequest(FederatedRequest.RequestType.EXEC_UDF, -1L, retriever);
        InetSocketAddress inetAddress = new InetSocketAddress(InetAddress.getByName(host), port);
        return FederatedData.executeFederatedOperation(inetAddress, privacyRetrieval);
    }

    private static PrivacyConstraint unwrapPrivConstraint(Future<FederatedResponse> privConstraintFuture) throws Exception {
        FederatedResponse privConstraintResponse = privConstraintFuture.get();
        return (PrivacyConstraint)privConstraintResponse.getData()[0];
    }

    public static class PrivacyConstraintRetriever
    extends FederatedUDF {
        private static final long serialVersionUID = 3551741240135587183L;
        private final String filename;

        public PrivacyConstraintRetriever(String filename) {
            super(new long[0]);
            this.filename = filename;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public FederatedResponse execute(ExecutionContext ec, Data ... data) {
            PrivacyConstraint privacyConstraint;
            FileSystem fs = null;
            try {
                String mtdname = DataExpression.getMTDFileName(this.filename);
                Path path = new Path(mtdname);
                fs = IOUtilFunctions.getFileSystem(mtdname);
                try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fs.open(path)));){
                    JSONObject metadataObject = JSONHelper.parse(br);
                    privacyConstraint = PrivacyPropagator.parseAndReturnPrivacyConstraint(metadataObject);
                }
            }
            catch (FederatedWorkerHandlerException | DMLPrivacyException ex) {
                try {
                    throw ex;
                    catch (Exception ex2) {
                        String msg = "Exception in reading metadata of: " + this.filename;
                        throw new DMLRuntimeException(msg);
                    }
                }
                catch (Throwable throwable) {
                    IOUtilFunctions.closeSilently(fs);
                    throw throwable;
                }
            }
            IOUtilFunctions.closeSilently((Closeable)fs);
            return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS, privacyConstraint);
        }

        @Override
        public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
            return null;
        }
    }
}

