/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.iogen;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.iogen.CustomProperties;
import org.apache.sysds.runtime.iogen.RawRow;
import org.apache.sysds.runtime.iogen.ValueTrimFormat;
import org.apache.sysds.runtime.matrix.data.FrameBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.Pair;

public abstract class ReaderMapping {
    protected int[][] mapRow;
    protected int[][] mapCol;
    protected boolean symmetric;
    protected boolean skewSymmetric;
    protected boolean isUpperTriangular;
    protected int skewCoefficient;
    protected final ArrayList<RawRow> sampleRawRows;
    protected boolean mapped;
    protected static int nrows;
    protected static int ncols;
    protected final int nlines;
    protected int firstRowIndex;
    protected int firstColIndex;
    protected ValueTrimFormat[][] VTF;
    protected ValueTrimFormat[][] VTFClone = null;

    public ReaderMapping(String raw) throws Exception {
        String value;
        InputStream is = IOUtilFunctions.toInputStream(raw);
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        int nlines = 0;
        this.sampleRawRows = new ArrayList();
        while ((value = br.readLine()) != null) {
            this.sampleRawRows.add(new RawRow(value));
            ++nlines;
        }
        this.nlines = nlines;
        this.firstColIndex = 0;
        this.firstRowIndex = 0;
    }

    protected abstract boolean isSchemaNumeric();

    protected void cloneSample() {
        if (this.VTFClone == null) {
            this.VTFClone = new ValueTrimFormat[nrows][ncols];
            for (int r = 0; r < nrows; ++r) {
                for (int c = 0; c < ncols; ++c) {
                    this.VTFClone[r][c] = this.VTF[r][c].getACopy();
                }
            }
        }
    }

    protected void retrieveSample() {
        for (int r = 0; r < nrows; ++r) {
            for (int c = 0; c < ncols; ++c) {
                this.VTF[r][c] = this.VTFClone[r][c].getACopy();
            }
        }
    }

    protected void transferSampleTriangular(boolean isUpper) throws Exception {
        if (nrows != ncols) {
            throw new Exception("For upper triangular both Row and Col should be same!");
        }
        for (int r = 0; r < nrows; ++r) {
            int c;
            if (isUpper) {
                for (c = 0; c < r; ++c) {
                    this.VTF[r][c].setNoSet();
                }
                continue;
            }
            for (c = r + 1; c < ncols; ++c) {
                this.VTF[r][c].setNoSet();
            }
        }
    }

    protected void transferSampleSkew(int coefficient) throws Exception {
        if (coefficient != 1 && coefficient != -1) {
            throw new Exception("The value of Coefficient have to be 1 or -1!");
        }
        for (int r = 0; r < nrows; ++r) {
            for (int c = 0; c < ncols; ++c) {
                if (this.VTF[r][c].isNotSet() || !this.VTF[r][c].getValueType().isNumeric()) continue;
                this.VTF[r][c] = new ValueTrimFormat(this.VTF[r][c].getColIndex(), this.VTF[r][c].getValueType(), this.VTF[r][c].getDoubleActualValue() * (double)coefficient);
            }
        }
    }

    protected abstract ValueTrimFormat[][] convertSampleTOValueTrimFormat();

    public void runMapping() throws Exception {
        this.mapped = this.findMapping();
        boolean schemaNumeric = this.isSchemaNumeric();
        if (!this.mapped) {
            this.cloneSample();
            this.symmetric = nrows == ncols;
            this.skewSymmetric = nrows == ncols && schemaNumeric;
            for (int r = 0; r < nrows; ++r) {
                for (int c = 0; c < ncols; ++c) {
                    if (this.symmetric) {
                        this.symmetric = this.VTF[r][c].isEqual(this.VTF[c][r]);
                    }
                    if (!this.skewSymmetric) continue;
                    this.skewSymmetric = r != c ? this.VTF[r][c].getDoubleActualValue() == this.VTF[c][r].getDoubleActualValue() * -1.0 : this.VTF[r][c].isNotSet();
                }
            }
            boolean isRR = this.isRowRegular();
            if (this.symmetric) {
                this.isUpperTriangular = false;
                this.transferSampleTriangular(this.isUpperTriangular);
                boolean bl = isRR ? this.findMapping() : (this.mapped = this.findMapping() && this.verifyRISymmetricMapping(this.isUpperTriangular));
                if (!this.mapped) {
                    this.isUpperTriangular = true;
                    this.retrieveSample();
                    this.transferSampleTriangular(this.isUpperTriangular);
                    this.mapped = isRR ? this.findMapping() : this.findMapping() && this.verifyRISymmetricMapping(this.isUpperTriangular);
                }
            } else if (this.skewSymmetric) {
                this.isUpperTriangular = false;
                this.transferSampleTriangular(this.isUpperTriangular);
                boolean bl = isRR ? this.findMapping() : (this.mapped = this.findMapping() && this.verifyRISymmetricMapping(this.isUpperTriangular));
                if (!this.mapped) {
                    this.skewCoefficient = -1;
                    this.transferSampleSkew(this.skewCoefficient);
                    boolean bl2 = isRR ? this.findMapping() : (this.mapped = this.findMapping() && this.verifyRISymmetricMapping(this.isUpperTriangular));
                }
                if (!this.mapped) {
                    this.isUpperTriangular = true;
                    this.skewCoefficient = 1;
                    this.retrieveSample();
                    this.transferSampleTriangular(this.isUpperTriangular);
                    boolean bl3 = isRR ? this.findMapping() : (this.mapped = this.findMapping() && this.verifyRISymmetricMapping(this.isUpperTriangular));
                }
                if (!this.mapped) {
                    this.skewCoefficient = -1;
                    this.transferSampleSkew(this.skewCoefficient);
                    this.mapped = isRR ? this.findMapping() : this.findMapping() && this.verifyRISymmetricMapping(this.isUpperTriangular);
                }
            }
        }
    }

    protected boolean findMapping() {
        this.mapRow = new int[nrows][ncols];
        this.mapCol = new int[nrows][ncols];
        for (int r = 0; r < nrows; ++r) {
            for (int c = 0; c < ncols; ++c) {
                this.mapCol[r][c] = -1;
                this.mapRow[r][c] = -1;
            }
        }
        for (int i = 0; i < this.nlines; ++i) {
            this.sampleRawRows.get(i).resetReserved();
        }
        int itRow = 0;
        for (int r = 0; r < nrows; ++r) {
            ArrayList<ValueTrimFormat> vtfRow = new ArrayList<ValueTrimFormat>();
            for (int i = 0; i < ncols; ++i) {
                if (this.VTF[r][i].isNotSet()) continue;
                vtfRow.add(this.VTF[r][i]);
            }
            Collections.sort(vtfRow);
            block5: for (ValueTrimFormat vtf : vtfRow) {
                int c = vtf.getColIndex();
                HashSet<Integer> checkedLines = new HashSet<Integer>();
                while (checkedLines.size() < this.nlines) {
                    RawRow row = this.sampleRawRows.get(itRow);
                    Pair<Integer, Integer> mi = row.findValue(vtf, false);
                    if (mi.getKey() != -1) {
                        this.mapRow[r][c] = itRow;
                        this.mapCol[r][c] = mi.getKey();
                        continue block5;
                    }
                    checkedLines.add(itRow);
                    if (++itRow != this.nlines) continue;
                    itRow = 0;
                }
            }
        }
        boolean flagMap = true;
        for (int r = 0; r < nrows && flagMap; ++r) {
            for (int c = 0; c < ncols && flagMap; ++c) {
                if (this.mapRow[r][c] != -1 || this.VTF[r][c].isNotSet()) continue;
                flagMap = false;
            }
        }
        return flagMap;
    }

    private boolean verifyRISymmetricMapping(boolean upperTriangular) {
        boolean result = false;
        int[] rowIndex = new int[]{0, 1, 0, 1};
        int[] colIndex = new int[]{0, 1, 1, 0};
        for (int i = 0; i < rowIndex.length && !result; ++i) {
            result = this.verifyRISymmetricMapping(upperTriangular, rowIndex[i], colIndex[i]);
            if (!result) continue;
            this.firstRowIndex = rowIndex[i];
            this.firstColIndex = colIndex[i];
        }
        return result;
    }

    private boolean verifyRISymmetricMapping(boolean upperTriangular, int firstRowIndex, int firstColIndex) {
        HashSet<Integer> checkedRow = new HashSet<Integer>();
        boolean rcvMapped = true;
        for (int r = nrows - 2; r >= 0 && rcvMapped; --r) {
            int selectedIndex;
            int n = selectedIndex = upperTriangular ? Math.min(r + 1, nrows - 1) : Math.max(r - 1, 0);
            if (r == selectedIndex) break;
            int lindeIndex = 0;
            rcvMapped = false;
            do {
                RawRow row;
                if (checkedRow.contains(lindeIndex) || this.VTF[r][selectedIndex].isNotSet() || !ReaderMapping.isMapRowColValue(row = this.sampleRawRows.get(lindeIndex).getResetClone(), r + firstRowIndex, selectedIndex + firstColIndex, this.VTF[r][selectedIndex])) continue;
                checkedRow.add(lindeIndex);
                rcvMapped = true;
            } while (++lindeIndex < this.nlines && !rcvMapped);
        }
        return rcvMapped;
    }

    public final CustomProperties getFormatProperties() throws Exception {
        CustomProperties ffp;
        if (this.isRowRegular()) {
            ffp = this.getFileFormatPropertiesOfRRCRMapping();
            if (ffp == null) {
                ffp = this.getFileFormatPropertiesOfRRCIMapping();
            }
        } else {
            ffp = this.getFileFormatPropertiesOfRIMapping();
        }
        return ffp;
    }

    public final boolean isRowRegular() {
        int nrows = this.mapRow.length;
        int ncols = this.mapRow[0].length;
        boolean result = true;
        int rValue = -1;
        for (int c = 0; c < ncols; ++c) {
            if (this.mapRow[0][c] == -1) continue;
            rValue = this.mapRow[0][c];
            break;
        }
        for (int r = 0; r < nrows && result; ++r) {
            for (int c = 0; c < ncols && result; ++c) {
                if (this.mapRow[r][c] == -1 || this.mapRow[r][c] == rValue + r) continue;
                result = false;
            }
        }
        return result;
    }

    public final CustomProperties getFileFormatPropertiesOfRRCRMapping() {
        ArrayList<String> rowDelims = new ArrayList<String>();
        HashSet<String> naString = new HashSet<String>();
        String stringToken = null;
        for (int r = 0; r < nrows; ++r) {
            RawRow rr = this.sampleRawRows.get(r);
            Pair<String, String> pair = rr.getDelims();
            rowDelims.add(pair.getValue());
            if (stringToken != null && (pair.getKey().length() <= 0 || stringToken.length() <= pair.getKey().length())) continue;
            stringToken = pair.getKey();
        }
        if (stringToken.length() == 0) {
            stringToken = (String)rowDelims.get(0);
        }
        String uniqueDelimiter = null;
        StringBuilder token = new StringBuilder();
        char[] cArray = stringToken.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character ch = Character.valueOf(cArray[i]);
            token.append(ch);
            boolean flagCurrToken = true;
            HashSet<String> ns = new HashSet<String>();
            FastStringTokenizer fastStringTokenizer = new FastStringTokenizer(token.toString());
            for (int r = 0; r < nrows; ++r) {
                String row = (String)rowDelims.get(r);
                fastStringTokenizer.reset(row);
                ArrayList<String> delimsOfToken = fastStringTokenizer.getTokens();
                for (String s : delimsOfToken) {
                    try {
                        Double.parseDouble(s);
                    }
                    catch (Exception ex) {
                        ns.add(s);
                    }
                }
                if (fastStringTokenizer._count == ncols - 1) continue;
                flagCurrToken = false;
                break;
            }
            if (!flagCurrToken) continue;
            uniqueDelimiter = token.toString();
            naString = ns;
        }
        if (uniqueDelimiter != null) {
            CustomProperties ffpgr = new CustomProperties(CustomProperties.GRPattern.Regular, uniqueDelimiter, naString);
            ffpgr.setDescription("CSV Format Recognized");
            return ffpgr;
        }
        return null;
    }

    private CustomProperties getFileFormatPropertiesOfRIMapping() {
        int[] rowIndex = new int[]{0, 1, 0, 1};
        int[] colIndex = new int[]{0, 1, 1, 0};
        CustomProperties ffp = null;
        for (int i = 0; i < rowIndex.length && ffp == null; ++i) {
            ffp = this.getDelimsOfMapping(rowIndex[i], colIndex[i]);
            if (ffp == null) continue;
            this.firstRowIndex = rowIndex[i];
            this.firstColIndex = colIndex[i];
        }
        if (ffp != null) {
            ffp.setFirstColIndex(this.firstColIndex);
            ffp.setFirstRowIndex(this.firstRowIndex);
            ffp.setDescription("Market Matrix Format Recognized: FirstRowIndex: " + this.firstRowIndex + " and  FirstColIndex: " + this.firstColIndex);
        }
        return ffp;
    }

    private CustomProperties getDelimsOfMapping(int firstRowIndex, int firstColIndex) {
        HashSet delims = new HashSet();
        int minDelimLength = -1;
        boolean rcvMapped = false;
        int selectedRowIndex = nrows - 2;
        int selectedColIndex = ncols - 1;
        for (int c = ncols - 1; c >= 0; --c) {
            if (this.VTF[selectedRowIndex][c].isNotSet()) continue;
            selectedColIndex = c;
            break;
        }
        int lindeIndex = 0;
        do {
            RawRow row;
            if (!ReaderMapping.isMapRowColValue(row = this.sampleRawRows.get(lindeIndex).getResetClone(), selectedRowIndex + firstRowIndex, selectedColIndex + firstColIndex, this.VTF[selectedRowIndex][selectedColIndex])) continue;
            rcvMapped = true;
            Pair<HashSet<String>, Integer> pair = row.getDelimsSet();
            delims.addAll(pair.getKey());
            int n = minDelimLength = minDelimLength == -1 ? pair.getValue() : Math.min(minDelimLength, pair.getValue());
        } while (++lindeIndex < this.nlines && !rcvMapped);
        if (!rcvMapped) {
            return null;
        }
        String uniqueDelim = null;
        for (int l = 1; l < minDelimLength + 1; ++l) {
            boolean flagToken = true;
            HashSet<String> token = new HashSet<String>();
            for (String delim : delims) {
                if (delim.length() % l != 0) {
                    flagToken = false;
                    break;
                }
                for (int i = 0; i <= delim.length() - l; i += l) {
                    token.add(delim.substring(i, i + l));
                }
                if (token.size() <= 1) continue;
                flagToken = false;
                break;
            }
            if (!flagToken) continue;
            if (token.size() <= 0) break;
            uniqueDelim = (String)token.iterator().next();
            break;
        }
        if (uniqueDelim != null) {
            CustomProperties.GRSymmetry symmetry = this.symmetric ? CustomProperties.GRSymmetry.SYMMETRIC : (this.skewSymmetric ? CustomProperties.GRSymmetry.SKEW_SYMMETRIC : CustomProperties.GRSymmetry.GENERAL);
            return new CustomProperties(symmetry, uniqueDelim, firstRowIndex, firstColIndex);
        }
        return null;
    }

    public CustomProperties getFileFormatPropertiesOfRRCIMapping() {
        int firstColIndex = 0;
        CustomProperties ffplibsvm = this.getDelimsOfRRCIMapping(firstColIndex);
        if (ffplibsvm == null) {
            firstColIndex = 1;
            ffplibsvm = this.getDelimsOfRRCIMapping(firstColIndex);
        }
        if (ffplibsvm != null) {
            ffplibsvm.setDescription("LibSVM Format Recognized: First Index Started From " + firstColIndex);
            ffplibsvm.setFirstColIndex(firstColIndex);
        }
        return ffplibsvm;
    }

    private CustomProperties getDelimsOfRRCIMapping(int firstColIndex) {
        HashMap<String, HashSet> tokens = new HashMap<String, HashSet>();
        HashSet allTokens = new HashSet();
        int maxNNZCount = 0;
        int selectedRowIndex = 0;
        for (int r = 0; r < nrows; ++r) {
            int rnnz = 0;
            for (int c = 0; c < ncols; ++c) {
                if (this.VTF[r][c].isNotSet()) continue;
                ++rnnz;
            }
            if (maxNNZCount >= rnnz) continue;
            maxNNZCount = rnnz;
            selectedRowIndex = r;
        }
        RawRow row = this.sampleRawRows.get(selectedRowIndex);
        for (int c = ncols - 1; c >= 0; --c) {
            ValueTrimFormat v = this.VTF[selectedRowIndex][c];
            if (v.isNotSet()) continue;
            String key = c + firstColIndex + "," + v.getStringOfActualValue();
            HashSet token = tokens.computeIfAbsent(key, k -> new HashSet());
            token.addAll(ReaderMapping.getColIndexValueMappedTokens(row, c + firstColIndex, v));
            allTokens.addAll(token);
        }
        ArrayList<String> missedKeys = new ArrayList<String>();
        HashSet<Integer> labelIndex = new HashSet<Integer>();
        ArrayList<String> selectedTokens = new ArrayList<String>();
        for (String key : tokens.keySet()) {
            if (((HashSet)tokens.get(key)).size() != 0) continue;
            missedKeys.add(key);
        }
        if (missedKeys.size() > 1) {
            return null;
        }
        for (String t : allTokens) {
            missedKeys.clear();
            for (String key : tokens.keySet()) {
                if (((HashSet)tokens.get(key)).contains(t)) continue;
                missedKeys.add(key);
            }
            if (missedKeys.size() != 1) continue;
            int li = Integer.parseInt(((String)missedKeys.iterator().next()).split(",")[0]);
            labelIndex.add(li);
            selectedTokens.add(t);
        }
        String separator = null;
        String indexSeparator = null;
        boolean isVerify = false;
        for (int i = 0; i < selectedTokens.size() && !isVerify; ++i) {
            isVerify = true;
            indexSeparator = (String)selectedTokens.get(i);
            row = this.sampleRawRows.get(selectedRowIndex).getResetClone();
            ArrayList<ValueTrimFormat> vtfValueList = new ArrayList<ValueTrimFormat>();
            ValueTrimFormat vtfIndexDelim = new ValueTrimFormat(indexSeparator);
            for (int c = 0; c < ncols; ++c) {
                if (this.VTF[selectedRowIndex][c].isNotSet() || labelIndex.contains(c + firstColIndex)) continue;
                vtfValueList.add(this.VTF[selectedRowIndex][c].getACopy());
            }
            Collections.sort(vtfValueList);
            for (ValueTrimFormat vtf : vtfValueList) {
                ArrayList<ValueTrimFormat> indexDelimValue = new ArrayList<ValueTrimFormat>();
                ValueTrimFormat vtfColIndex = new ValueTrimFormat(vtf.getColIndex() + firstColIndex);
                indexDelimValue.add(vtfColIndex);
                indexDelimValue.add(vtfIndexDelim);
                indexDelimValue.add(vtf);
                row.findSequenceValues(indexDelimValue, 0, true);
            }
            for (Integer li : labelIndex) {
                row.findValue(this.VTF[selectedRowIndex][li - firstColIndex], false);
            }
            separator = row.getDelims().getKey();
            if (separator != null) continue;
            isVerify = false;
            break;
        }
        if (isVerify) {
            return new CustomProperties(CustomProperties.GRPattern.Regular, separator, indexSeparator, firstColIndex);
        }
        return null;
    }

    private static boolean isMapRowColValue(RawRow rawrow, int row, int col, ValueTrimFormat value) {
        ValueTrimFormat vtfRow = new ValueTrimFormat(row);
        ValueTrimFormat vtfCol = new ValueTrimFormat(col);
        ValueTrimFormat vtfValue = value.getACopy();
        boolean mapped = true;
        int hasZero = 0;
        if (vtfRow.isNotSet()) {
            hasZero = (byte)(hasZero | 4);
        }
        if (vtfCol.isNotSet()) {
            hasZero = (byte)(hasZero | 2);
        }
        if (vtfValue.isNotSet()) {
            hasZero = (byte)(hasZero | 1);
        }
        ValueTrimFormat[] order = new ValueTrimFormat[3];
        switch (hasZero) {
            case 0: {
                order[0] = vtfRow;
                order[1] = vtfCol;
                order[2] = vtfValue;
                break;
            }
            case 2: {
                order[0] = vtfRow;
                order[1] = vtfValue;
                order[2] = vtfCol;
                break;
            }
            case 4: {
                order[0] = vtfCol;
                order[1] = vtfValue;
                order[2] = vtfRow;
                break;
            }
            case 6: {
                order[0] = vtfValue;
                order[1] = vtfRow;
                order[2] = vtfCol;
                break;
            }
            default: {
                throw new RuntimeException("Not set values can't be find on a string");
            }
        }
        for (ValueTrimFormat vtf : order) {
            if (rawrow.findValue(vtf, false).getKey() != -1) continue;
            mapped = false;
            break;
        }
        return mapped;
    }

    private static HashSet<String> getColIndexValueMappedTokens(RawRow rawrow, int col, ValueTrimFormat value) {
        ValueTrimFormat vtfColIndex = new ValueTrimFormat(col);
        ValueTrimFormat vtfColValue = value.getACopy();
        HashSet<String> tokens = new HashSet<String>();
        RawRow row = rawrow.getResetClone();
        int lastIndex = 0;
        int lastTokenStart = -1;
        int lastTokenEnd = -1;
        int lastTokenID = -1;
        while (true) {
            row.resetReserved();
            row.setLastIndex(lastIndex);
            Pair<Integer, Integer> pairCol = row.findValue(vtfColIndex, true);
            if (pairCol.getKey() == -1) break;
            lastIndex = row.getNumericLastIndex();
            Pair<Integer, Integer> pairValue = row.findValue(vtfColValue, true);
            if (pairValue.getKey() == -1) break;
            int tl = pairValue.getKey() - pairCol.getKey() + pairCol.getValue();
            if (tl <= 0) continue;
            if (lastTokenID == -1) {
                lastTokenID = pairValue.getKey();
            }
            if (lastTokenID != pairValue.getKey()) {
                String token = row.getRaw().substring(lastTokenStart, lastTokenEnd);
                tokens.add(token);
            }
            lastTokenStart = pairCol.getKey() + pairCol.getValue();
            lastTokenEnd = pairValue.getKey();
        }
        if (lastTokenEnd - lastTokenStart > 0) {
            String token = row.getRaw().substring(lastTokenStart, lastTokenEnd);
            tokens.add(token);
        }
        return tokens;
    }

    public boolean isSymmetric() {
        return this.symmetric;
    }

    public boolean isMapped() {
        return this.mapped;
    }

    private static class FastStringTokenizer
    implements Serializable {
        private static final long serialVersionUID = -4698672725609750097L;
        private String _string = null;
        private String _del = "";
        private int _pos = -1;
        private int _count = 0;

        public FastStringTokenizer(String delimiter) {
            this._del = delimiter;
            this.reset(null);
        }

        public void reset(String string) {
            this._string = string;
            this._pos = 0;
            this._count = 0;
        }

        private String nextToken() {
            int len = this._string.length();
            int start = this._pos;
            while (start != -1 && start < len && this._del.equals(this._string.substring(start, Math.min(start + this._del.length(), this._string.length())))) {
                start += this._del.length();
                ++this._count;
            }
            if (start < len && start != -1) {
                this._pos = this._string.indexOf(this._del, start);
                if (start < this._pos && this._pos < len) {
                    return this._string.substring(start, this._pos);
                }
                return this._string.substring(start);
            }
            return null;
        }

        public ArrayList<String> getTokens() {
            String token;
            ArrayList<String> tokens = new ArrayList<String>();
            tokens.add("");
            do {
                if ((token = this.nextToken()) == null) continue;
                tokens.add(token);
            } while (token != null);
            return tokens;
        }
    }

    public static class FrameReaderMapping
    extends ReaderMapping {
        private FrameBlock sampleFrame;
        private Types.ValueType[] schema;

        public FrameReaderMapping(String raw, FrameBlock frame) throws Exception {
            super(raw);
            this.sampleFrame = frame;
            nrows = this.sampleFrame.getNumRows();
            ncols = this.sampleFrame.getNumColumns();
            this.schema = this.sampleFrame.getSchema();
            this.VTF = this.convertSampleTOValueTrimFormat();
            this.runMapping();
        }

        @Override
        protected ValueTrimFormat[][] convertSampleTOValueTrimFormat() {
            ValueTrimFormat[][] result = new ValueTrimFormat[nrows][ncols];
            for (int r = 0; r < nrows; ++r) {
                for (int c = 0; c < ncols; ++c) {
                    result[r][c] = new ValueTrimFormat(c, this.schema[c], this.sampleFrame.get(r, c));
                }
            }
            return result;
        }

        @Override
        protected boolean isSchemaNumeric() {
            boolean result = true;
            for (Types.ValueType vt : this.schema) {
                result &= vt.isNumeric();
            }
            return result;
        }
    }

    public static class MatrixReaderMapping
    extends ReaderMapping {
        private MatrixBlock sampleMatrix;

        public MatrixReaderMapping(String raw, MatrixBlock matrix) throws Exception {
            super(raw);
            this.sampleMatrix = matrix;
            nrows = this.sampleMatrix.getNumRows();
            ncols = this.sampleMatrix.getNumColumns();
            this.VTF = this.convertSampleTOValueTrimFormat();
            this.runMapping();
        }

        @Override
        protected ValueTrimFormat[][] convertSampleTOValueTrimFormat() {
            ValueTrimFormat[][] result = new ValueTrimFormat[nrows][ncols];
            for (int r = 0; r < nrows; ++r) {
                for (int c = 0; c < ncols; ++c) {
                    result[r][c] = new ValueTrimFormat(c, Types.ValueType.FP64, this.sampleMatrix.getValue(r, c));
                }
            }
            return result;
        }

        @Override
        protected boolean isSchemaNumeric() {
            return true;
        }
    }
}

