/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.federated.monitoring.services;

import java.net.InetSocketAddress;
import java.util.concurrent.Future;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.federated.FederatedData;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.apache.sysds.runtime.controlprogram.federated.FederatedStatistics;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.BaseEntityModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.StatsEntityModel;

public class StatsService {
    public static BaseEntityModel getWorkerStatistics(Long id, String address) {
        StatsEntityModel parsedStats = null;
        try {
            FederatedResponse statisticsResponse = StatsService.sendStatisticsRequest(address).get();
            if (statisticsResponse.isSuccessful()) {
                FederatedStatistics.FedStatsCollection aggFedStats = new FederatedStatistics.FedStatsCollection();
                Object[] tmp = statisticsResponse.getData();
                if (tmp[0] instanceof FederatedStatistics.FedStatsCollection) {
                    aggFedStats.aggregate((FederatedStatistics.FedStatsCollection)tmp[0]);
                }
                parsedStats = new StatsEntityModel(id, aggFedStats.cpuUsage, aggFedStats.memoryUsage, aggFedStats.heavyHitters, aggFedStats.coordinatorsTrafficBytes);
            }
        }
        catch (DMLRuntimeException statisticsResponse) {
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return parsedStats;
    }

    private static Future<FederatedResponse> sendStatisticsRequest(String address) {
        Future<FederatedResponse> result = null;
        String host = address.split(":")[0];
        int port = Integer.parseInt(address.split(":")[1]);
        InetSocketAddress isa = new InetSocketAddress(host, port);
        FederatedRequest frUDF = new FederatedRequest(FederatedRequest.RequestType.EXEC_UDF, -1L, new FederatedStatistics.FedStatsCollectFunction());
        try {
            result = FederatedData.executeFederatedOperation(isa, frUDF);
        }
        catch (DMLRuntimeException dre) {
            throw dre;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }
}

