/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.io.TensorReader;
import org.apache.sysds.runtime.io.TensorReaderBinaryBlock;
import org.apache.sysds.runtime.io.TensorReaderTextCell;

public class TensorReaderFactory {
    public static TensorReader createTensorReader(Types.FileFormat fmt) {
        TensorReader reader;
        if (fmt == Types.FileFormat.TEXT) {
            reader = new TensorReaderTextCell();
        } else if (fmt == Types.FileFormat.BINARY) {
            reader = new TensorReaderBinaryBlock();
        } else {
            throw new DMLRuntimeException("Failed to create tensor reader for unknown format: " + fmt.toString());
        }
        return reader;
    }
}

