/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.mapping;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToBit;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToByte;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToZero;

public class MapToUByte
extends MapToByte {
    private static final long serialVersionUID = -2498505439667351828L;

    protected MapToUByte(int size) {
        this(127, size);
    }

    public MapToUByte(int unique, int size) {
        super(Math.min(unique, 127), new byte[size]);
    }

    protected MapToUByte(int unique, byte[] data) {
        super(unique, data);
    }

    @Override
    public MapToFactory.MAP_TYPE getType() {
        return MapToFactory.MAP_TYPE.UBYTE;
    }

    @Override
    public int getIndex(int n) {
        return this._data[n];
    }

    @Override
    public int setAndGet(int n, int v) {
        this._data[n] = (byte)v;
        return this._data[n];
    }

    @Override
    public void fill(int v) {
        Arrays.fill(this._data, (byte)(v % 128));
    }

    public static long getInMemorySize(int dataLength) {
        return MapToByte.getInMemorySize(dataLength);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(MapToFactory.MAP_TYPE.UBYTE.ordinal());
        super.writeBytes(out);
    }

    protected static MapToUByte readFields(DataInput in) throws IOException {
        int unique = in.readInt();
        int length = in.readInt();
        byte[] data = new byte[length];
        for (int i = 0; i < length; ++i) {
            data[i] = in.readByte();
        }
        return new MapToUByte(unique, data);
    }

    @Override
    public void replace(int v, int r) {
        byte cv = (byte)v;
        byte rv = (byte)(r % 128);
        for (int i = 0; i < this.size(); ++i) {
            if (this._data[i] != cv) continue;
            this._data[i] = rv;
        }
    }

    @Override
    protected void preAggregateDenseToRowBy8(double[] mV, double[] preAV, int cl, int cu, int off) {
        int h = (cu - cl) % 8;
        off += cl;
        int rc = cl;
        while (rc < cl + h) {
            int n = this.getIndex(rc);
            preAV[n] = preAV[n] + mV[off];
            ++rc;
            ++off;
        }
        rc = cl + h;
        while (rc < cu) {
            this.preAggregateDenseToRowVec8(mV, preAV, rc, off);
            rc += 8;
            off += 8;
        }
    }

    @Override
    protected void preAggregateDenseToRowVec8(double[] mV, double[] preAV, int rc, int off) {
        int n = this.getIndex(rc);
        preAV[n] = preAV[n] + mV[off];
        int n2 = this.getIndex(rc + 1);
        preAV[n2] = preAV[n2] + mV[off + 1];
        int n3 = this.getIndex(rc + 2);
        preAV[n3] = preAV[n3] + mV[off + 2];
        int n4 = this.getIndex(rc + 3);
        preAV[n4] = preAV[n4] + mV[off + 3];
        int n5 = this.getIndex(rc + 4);
        preAV[n5] = preAV[n5] + mV[off + 4];
        int n6 = this.getIndex(rc + 5);
        preAV[n6] = preAV[n6] + mV[off + 5];
        int n7 = this.getIndex(rc + 6);
        preAV[n7] = preAV[n7] + mV[off + 6];
        int n8 = this.getIndex(rc + 7);
        preAV[n8] = preAV[n8] + mV[off + 7];
    }

    @Override
    public int getUpperBoundValue() {
        return 127;
    }

    @Override
    public int[] getCounts(int[] ret) {
        for (int i = 0; i < this._data.length; ++i) {
            byte by = this._data[i];
            ret[by] = ret[by] + 1;
        }
        return ret;
    }

    @Override
    public int getMaxPossible() {
        return 128;
    }

    @Override
    public AMapToData resize(int unique) {
        int size = this._data.length;
        if (unique <= 1) {
            return new MapToZero(size);
        }
        if (unique == 2 && size > 32) {
            MapToBit ret = new MapToBit(unique, size);
            ((AMapToData)ret).copy(this);
            return ret;
        }
        this.setUnique(unique);
        return this;
    }
}

