/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim.encoding;

import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.colgroup.offset.AIterator;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffset;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetFactory;
import org.apache.sysds.runtime.compress.estim.EstimationFactors;
import org.apache.sysds.runtime.compress.estim.encoding.AEncode;
import org.apache.sysds.runtime.compress.estim.encoding.ConstEncoding;
import org.apache.sysds.runtime.compress.estim.encoding.DenseEncoding;
import org.apache.sysds.runtime.compress.estim.encoding.EmptyEncoding;
import org.apache.sysds.runtime.compress.estim.encoding.IEncode;
import org.apache.sysds.runtime.compress.utils.HashMapLongInt;
import org.apache.sysds.runtime.compress.utils.IntArrayList;

public class SparseEncoding
extends AEncode {
    protected final AMapToData map;
    protected final AOffset off;
    protected final int nRows;

    protected SparseEncoding(AMapToData map, AOffset off, int nRows) {
        this.map = map;
        this.off = off;
        this.nRows = nRows;
        if (CompressedMatrixBlock.debug) {
            int[] freq = map.getCounts();
            for (int i = 0; i < freq.length; ++i) {
                if (freq[i] != 0) continue;
                throw new DMLCompressionException("Invalid counts in fact contains 0");
            }
        }
    }

    @Override
    public IEncode combine(IEncode e) {
        if (e instanceof EmptyEncoding || e instanceof ConstEncoding) {
            return this;
        }
        if (e instanceof SparseEncoding) {
            SparseEncoding es = (SparseEncoding)e;
            if (es.off == this.off && es.map == this.map) {
                return this;
            }
            return this.combineSparse(es);
        }
        return e.combine(this);
    }

    @Override
    public Pair<IEncode, HashMapLongInt> combineWithMap(IEncode e) {
        if (e instanceof EmptyEncoding || e instanceof ConstEncoding) {
            return new ImmutablePair((Object)this, null);
        }
        if (e instanceof SparseEncoding) {
            SparseEncoding es = (SparseEncoding)e;
            if (es.off == this.off && es.map == this.map) {
                return new ImmutablePair((Object)this, null);
            }
            return this.combineSparseNoResizeDense(es);
        }
        throw new DMLCompressionException("Not allowed other to be dense. We should instead combine other way with sparse");
    }

    protected IEncode combineSparse(SparseEncoding e) {
        int sr;
        int maxUnique = e.getUnique() * this.getUnique();
        int[] d = new int[maxUnique - 1];
        int fl = this.off.getOffsetToLast();
        int fr = e.off.getOffsetToLast();
        AIterator itl = this.off.getIterator();
        AIterator itr = e.off.getIterator();
        int nVl = this.getUnique();
        int nVr = e.getUnique();
        int sl = this.map.size();
        if (sl + (sr = e.map.size()) > this.nRows / 2) {
            return SparseEncoding.combineSparseToDense(this.map, e.map, itl, itr, fl, fr, nVl, nVr, d, this.nRows, maxUnique);
        }
        IntArrayList retOff = new IntArrayList(Math.max(sr, sl));
        IntArrayList tmpVals = new IntArrayList(Math.max(sr, sl));
        int unique = SparseEncoding.combineSparse(this.map, e.map, itl, itr, retOff, tmpVals, fl, fr, nVl, nVr, d);
        if (retOff.size() < this.nRows / 4) {
            AOffset o = OffsetFactory.createOffset(retOff);
            AMapToData retMap = MapToFactory.create(tmpVals.size(), tmpVals.extractValues(), unique - 1);
            return new SparseEncoding(retMap, o, this.nRows);
        }
        AMapToData retMap = MapToFactory.create(this.nRows, unique);
        for (int i = 0; i < retOff.size(); ++i) {
            retMap.set(retOff.get(i), tmpVals.get(i) + 1);
        }
        return new DenseEncoding(retMap);
    }

    private Pair<IEncode, HashMapLongInt> combineSparseNoResizeDense(SparseEncoding e) {
        int fl = this.off.getOffsetToLast();
        int fr = e.off.getOffsetToLast();
        AIterator itl = this.off.getIterator();
        AIterator itr = e.off.getIterator();
        int nVl = this.getUnique();
        int nVr = e.getUnique();
        AMapToData retMap = MapToFactory.create(this.nRows, (nVl + 1) * (nVr + 1));
        int il = itl.value();
        while (il < fl) {
            retMap.set(il, this.map.getIndex(itl.getDataIndex()) + 1);
            il = itl.next();
        }
        retMap.set(fl, this.map.getIndex(itl.getDataIndex()) + 1);
        int ir = itr.value();
        while (ir < fr) {
            int vl = retMap.getIndex(ir);
            int vr = e.map.getIndex(itr.getDataIndex()) + 1;
            retMap.set(ir, vl + vr * nVl);
            ir = itr.next();
        }
        retMap.set(fr, retMap.getIndex(fr) + (e.map.getIndex(itr.getDataIndex()) + 1) * nVl);
        HashMapLongInt m = new HashMapLongInt(100);
        for (int i = 0; i < retMap.size(); ++i) {
            SparseEncoding.addValHashMap(retMap.getIndex(i), i, m, retMap);
        }
        return new ImmutablePair((Object)new DenseEncoding(retMap.resize(m.size())), (Object)m);
    }

    protected static void addValHashMap(int nv, int r, HashMapLongInt map, AMapToData d) {
        int v = map.size();
        int mv = map.putIfAbsent(nv, v);
        if (mv == -1) {
            d.set(r, v);
        } else {
            d.set(r, mv);
        }
    }

    private static int combineSparse(AMapToData lMap, AMapToData rMap, AIterator itl, AIterator itr, IntArrayList retOff, IntArrayList tmpVals, int fl, int fr, int nVl, int nVr, int[] d) {
        int defR = (nVr - 1) * nVl;
        int defL = nVl - 1;
        int newUID = 1;
        int il = itl.value();
        int ir = itr.value();
        while (il < fl && ir < fr) {
            int nv;
            if (il == ir) {
                nv = lMap.getIndex(itl.getDataIndex()) + rMap.getIndex(itr.getDataIndex()) * nVl;
                newUID = SparseEncoding.addVal(nv, il, d, newUID, tmpVals, retOff);
                il = itl.next();
                ir = itr.next();
                continue;
            }
            if (il < ir) {
                nv = lMap.getIndex(itl.getDataIndex()) + defR;
                newUID = SparseEncoding.addVal(nv, il, d, newUID, tmpVals, retOff);
                il = itl.next();
                continue;
            }
            nv = rMap.getIndex(itr.getDataIndex()) * nVl + defL;
            newUID = SparseEncoding.addVal(nv, ir, d, newUID, tmpVals, retOff);
            ir = itr.next();
        }
        newUID = SparseEncoding.combineSparseTail(lMap, rMap, itl, itr, retOff, tmpVals, fl, fr, nVl, nVr, d, newUID);
        return newUID;
    }

    private static int combineSparseTail(AMapToData lMap, AMapToData rMap, AIterator itl, AIterator itr, IntArrayList retOff, IntArrayList tmpVals, int fl, int fr, int nVl, int nVr, int[] d, int newUID) {
        int defR = (nVr - 1) * nVl;
        int defL = nVl - 1;
        int il = itl.value();
        int ir = itr.value();
        if (il == fl && ir == fr) {
            if (fl == fr) {
                int nv = lMap.getIndex(itl.getDataIndex()) + rMap.getIndex(itr.getDataIndex()) * nVl;
                return SparseEncoding.addVal(nv, il, d, newUID, tmpVals, retOff);
            }
            if (fl < fr) {
                int nv = lMap.getIndex(itl.getDataIndex()) + defR;
                newUID = SparseEncoding.addVal(nv, il, d, newUID, tmpVals, retOff);
                nv = rMap.getIndex(itr.getDataIndex()) * nVl + defL;
                newUID = SparseEncoding.addVal(nv, fr, d, newUID, tmpVals, retOff);
            } else {
                int nv = rMap.getIndex(itr.getDataIndex()) * nVl + defL;
                newUID = SparseEncoding.addVal(nv, fr, d, newUID, tmpVals, retOff);
                nv = lMap.getIndex(itl.getDataIndex()) + defR;
                newUID = SparseEncoding.addVal(nv, il, d, newUID, tmpVals, retOff);
            }
        } else if (il < fl) {
            int nv;
            if (fl < fr) {
                int nv2;
                while (il < fl) {
                    nv2 = lMap.getIndex(itl.getDataIndex()) + defR;
                    newUID = SparseEncoding.addVal(nv2, il, d, newUID, tmpVals, retOff);
                    il = itl.next();
                }
                nv2 = lMap.getIndex(itl.getDataIndex()) + defR;
                newUID = SparseEncoding.addVal(nv2, il, d, newUID, tmpVals, retOff);
                nv2 = rMap.getIndex(itr.getDataIndex()) * nVl + defL;
                newUID = SparseEncoding.addVal(nv2, fr, d, newUID, tmpVals, retOff);
                return newUID;
            }
            while (il < fr) {
                nv = lMap.getIndex(itl.getDataIndex()) + defR;
                newUID = SparseEncoding.addVal(nv, il, d, newUID, tmpVals, retOff);
                il = itl.next();
            }
            if (fl == fr) {
                nv = lMap.getIndex(itl.getDataIndex()) + rMap.getIndex(itr.getDataIndex()) * nVl;
                return SparseEncoding.addVal(nv, il, d, newUID, tmpVals, retOff);
            }
            if (il == fr) {
                nv = lMap.getIndex(itl.getDataIndex()) + rMap.getIndex(itr.getDataIndex()) * nVl;
                newUID = SparseEncoding.addVal(nv, il, d, newUID, tmpVals, retOff);
                il = itl.next();
            } else {
                nv = rMap.getIndex(itr.getDataIndex()) * nVl + defL;
                newUID = SparseEncoding.addVal(nv, fr, d, newUID, tmpVals, retOff);
            }
            while (il < fl) {
                nv = lMap.getIndex(itl.getDataIndex()) + defR;
                newUID = SparseEncoding.addVal(nv, il, d, newUID, tmpVals, retOff);
                il = itl.next();
            }
            nv = lMap.getIndex(itl.getDataIndex()) + defR;
            newUID = SparseEncoding.addVal(nv, il, d, newUID, tmpVals, retOff);
        } else {
            int nv;
            if (fr < fl) {
                int nv3;
                while (ir < fr) {
                    nv3 = rMap.getIndex(itr.getDataIndex()) * nVl + defL;
                    newUID = SparseEncoding.addVal(nv3, ir, d, newUID, tmpVals, retOff);
                    ir = itr.next();
                }
                nv3 = rMap.getIndex(itr.getDataIndex()) * nVl + defL;
                newUID = SparseEncoding.addVal(nv3, ir, d, newUID, tmpVals, retOff);
                nv3 = lMap.getIndex(itl.getDataIndex()) + defR;
                newUID = SparseEncoding.addVal(nv3, fl, d, newUID, tmpVals, retOff);
                return newUID;
            }
            while (ir < fl) {
                nv = rMap.getIndex(itr.getDataIndex()) * nVl + defL;
                newUID = SparseEncoding.addVal(nv, ir, d, newUID, tmpVals, retOff);
                ir = itr.next();
            }
            if (fr == fl) {
                nv = lMap.getIndex(itl.getDataIndex()) + rMap.getIndex(itr.getDataIndex()) * nVl;
                return SparseEncoding.addVal(nv, ir, d, newUID, tmpVals, retOff);
            }
            if (ir == fl) {
                nv = lMap.getIndex(itl.getDataIndex()) + rMap.getIndex(itr.getDataIndex()) * nVl;
                newUID = SparseEncoding.addVal(nv, ir, d, newUID, tmpVals, retOff);
                ir = itr.next();
            } else {
                nv = lMap.getIndex(itl.getDataIndex()) + defR;
                newUID = SparseEncoding.addVal(nv, fl, d, newUID, tmpVals, retOff);
            }
            while (ir < fr) {
                nv = rMap.getIndex(itr.getDataIndex()) * nVl + defL;
                newUID = SparseEncoding.addVal(nv, ir, d, newUID, tmpVals, retOff);
                ir = itr.next();
            }
            nv = rMap.getIndex(itr.getDataIndex()) * nVl + defL;
            newUID = SparseEncoding.addVal(nv, ir, d, newUID, tmpVals, retOff);
        }
        return newUID;
    }

    private static int addVal(int nv, int offset, int[] d, int newUID, IntArrayList tmpVals, IntArrayList offsets) {
        int mapV = d[nv];
        if (mapV == 0) {
            d[nv] = newUID++;
            mapV = d[nv];
        }
        tmpVals.appendValue(mapV - 1);
        offsets.appendValue(offset);
        return newUID;
    }

    private static DenseEncoding combineSparseToDense(AMapToData lMap, AMapToData rMap, AIterator itl, AIterator itr, int fl, int fr, int nVl, int nVr, int[] d, int nRows, int maxUnique) {
        AMapToData retMap = MapToFactory.create(nRows, (nVl + 1) * (nVr + 1));
        int il = itl.value();
        while (il < fl) {
            retMap.set(il, lMap.getIndex(itl.getDataIndex()) + 1);
            il = itl.next();
        }
        retMap.set(fl, lMap.getIndex(itl.getDataIndex()) + 1);
        int ir = itr.value();
        while (ir < fr) {
            int vl = retMap.getIndex(ir);
            int vr = rMap.getIndex(itr.getDataIndex()) + 1;
            retMap.set(ir, vl + vr * nVl);
            ir = itr.next();
        }
        retMap.set(fr, retMap.getIndex(fr) + (rMap.getIndex(itr.getDataIndex()) + 1) * nVl);
        AMapToData tmpMap = MapToFactory.create(maxUnique, maxUnique + 1);
        int newUID = 1;
        for (int r = 0; r < retMap.size(); ++r) {
            int nv = retMap.getIndex(r);
            int mv = tmpMap.getIndex(nv);
            if (mv == 0) {
                mv = tmpMap.setAndGet(nv, newUID++);
            }
            retMap.set(r, mv - 1);
        }
        retMap.setUnique(newUID - 1);
        return new DenseEncoding(retMap);
    }

    @Override
    public int getUnique() {
        return this.map.getUnique() + 1;
    }

    @Override
    public EstimationFactors extractFacts(int nRows, double tupleSparsity, double matrixSparsity, CompressionSettings cs) {
        int largestOffs = nRows - this.map.size();
        tupleSparsity = Math.min((double)this.map.size() / (double)nRows, tupleSparsity);
        int[] counts = this.map.getCounts();
        if (cs.isRLEAllowed()) {
            return new EstimationFactors(this.map.getUnique(), this.map.size(), largestOffs, counts, 0, nRows, this.map.countRuns(this.off), false, true, matrixSparsity, tupleSparsity);
        }
        return new EstimationFactors(this.map.getUnique(), this.map.size(), largestOffs, counts, 0, nRows, false, true, matrixSparsity, tupleSparsity);
    }

    @Override
    public boolean isDense() {
        return false;
    }

    public AOffset getOffsets() {
        return this.off;
    }

    public AMapToData getMap() {
        return this.map;
    }

    public int getNumRows() {
        return this.nRows;
    }

    @Override
    public boolean equals(IEncode e) {
        return e instanceof SparseEncoding && ((SparseEncoding)e).off.equals(this.off) && ((SparseEncoding)e).map.equals(this.map);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("\n");
        sb.append("mapping: ");
        sb.append(this.map);
        sb.append("\n");
        sb.append("offsets: ");
        sb.append(this.off);
        return sb.toString();
    }
}

