/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.spark;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.sysds.common.Opcodes;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.lops.MMTSJ;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.spark.SPInstruction;
import org.apache.sysds.runtime.instructions.spark.UnarySPInstruction;
import org.apache.sysds.runtime.instructions.spark.utils.RDDAggregateUtils;
import org.apache.sysds.runtime.lineage.LineageCacheConfig;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.util.CommonThreadPool;
import scala.Tuple2;

public class TsmmSPInstruction
extends UnarySPInstruction {
    private MMTSJ.MMTSJType _type = null;

    private TsmmSPInstruction(Operator op, CPOperand in1, CPOperand out, MMTSJ.MMTSJType type, String opcode, String istr) {
        super(SPInstruction.SPType.TSMM, op, in1, out, opcode, istr);
        this._type = type;
    }

    public static TsmmSPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (!opcode.equalsIgnoreCase(Opcodes.TSMM.toString())) {
            throw new DMLRuntimeException("TsmmSPInstruction.parseInstruction():: Unknown opcode " + opcode);
        }
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand out = new CPOperand(parts[2]);
        MMTSJ.MMTSJType type = MMTSJ.MMTSJType.valueOf(parts[3]);
        return new TsmmSPInstruction(null, in1, out, type, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        JavaPairRDD<MatrixIndexes, MatrixBlock> in = sec.getBinaryMatrixBlockRDDHandleForVariable(this.input1.getName());
        if (ConfigurationManager.isMaxPrallelizeEnabled()) {
            try {
                TsmmTask task = new TsmmTask(in, this._type);
                Future<MatrixBlock> future_out = CommonThreadPool.getDynamicPool().submit(task);
                LineageItem li = !LineageCacheConfig.ReuseCacheType.isNone() ? (LineageItem)this.getLineageItem(ec).getValue() : null;
                sec.setMatrixOutputAndLineage(this.output.getName(), future_out, li);
            }
            catch (Exception ex) {
                throw new DMLRuntimeException(ex);
            }
        } else {
            JavaRDD tmp = in.map((Function)new RDDTSMMFunction(this._type));
            MatrixBlock out = RDDAggregateUtils.sumStable((JavaRDD<MatrixBlock>)tmp);
            sec.setMatrixOutput(this.output.getName(), out);
        }
    }

    public MMTSJ.MMTSJType getMMTSJType() {
        return this._type;
    }

    private static class TsmmTask
    implements Callable<MatrixBlock> {
        JavaPairRDD<MatrixIndexes, MatrixBlock> _in;
        MMTSJ.MMTSJType _type;

        TsmmTask(JavaPairRDD<MatrixIndexes, MatrixBlock> in, MMTSJ.MMTSJType type) {
            this._in = in;
            this._type = type;
        }

        @Override
        public MatrixBlock call() {
            JavaRDD tmp = this._in.map((Function)new RDDTSMMFunction(this._type));
            return RDDAggregateUtils.sumStable((JavaRDD<MatrixBlock>)tmp);
        }
    }

    private static class RDDTSMMFunction
    implements Function<Tuple2<MatrixIndexes, MatrixBlock>, MatrixBlock> {
        private static final long serialVersionUID = 2935770425858019666L;
        private MMTSJ.MMTSJType _type = null;

        public RDDTSMMFunction(MMTSJ.MMTSJType type) {
            this._type = type;
        }

        public MatrixBlock call(Tuple2<MatrixIndexes, MatrixBlock> arg0) throws Exception {
            return ((MatrixBlock)arg0._2()).transposeSelfMatrixMultOperations(new MatrixBlock(), this._type);
        }
    }
}

