/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import java.util.List;
import org.apache.tapestry5.ComponentAction;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.PropertyOverrides;
import org.apache.tapestry5.ValueEncoder;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.beaneditor.PropertyModel;
import org.apache.tapestry5.grid.GridDataSource;
import org.apache.tapestry5.grid.GridModel;
import org.apache.tapestry5.services.FormSupport;

public class GridRows {
    private int startRow;
    private boolean recordStateByIndex;
    private boolean recordStateByEncoder;
    @Parameter(cache=false)
    private String rowClass;
    @Parameter(value="componentResources.container")
    private GridModel gridModel;
    @Parameter(required=true, allowNull=false)
    @Property
    private PropertyOverrides overrides;
    @Parameter(required=true)
    private int rowsPerPage;
    @Parameter(required=true)
    private int currentPage;
    @Parameter(required=true)
    @Property(write=false)
    private Object row;
    @Parameter
    private boolean lean;
    @Parameter(name="volatile")
    private boolean volatileState;
    @Parameter
    private ValueEncoder encoder;
    @Parameter
    private int rowIndex;
    @Parameter
    @Property
    private int columnIndex;
    @Environmental(value=false)
    private FormSupport formSupport;
    private int endRow;
    private int dataRowIndex;
    private String propertyName;
    @Property(write=false)
    private PropertyModel columnModel;

    void onBeginRenderFromRow(MarkupWriter writer) {
        String rc;
        if (this.dataRowIndex == this.startRow) {
            writer.attributes("data-grid-row", "first");
        }
        if (this.dataRowIndex == this.endRow) {
            writer.attributes("data-grid-row", "last");
        }
        if ((rc = this.rowClass) != null) {
            writer.attributes("class", rc);
        }
    }

    void onBeginRenderFromColumn(MarkupWriter writer) {
        String id = this.gridModel.getDataModel().get(this.propertyName).getId();
        if (!this.lean) {
            writer.attributes("data-grid-property", id);
        }
        switch (this.gridModel.getSortModel().getColumnSort(id)) {
            case ASCENDING: {
                writer.attributes("data-grid-column-sort", "ascending");
                break;
            }
            case DESCENDING: {
                writer.attributes("data-grid-column-sort", "descending");
                break;
            }
        }
    }

    void setupRender() {
        int numberOfRowsRequiredToFillCurrentPage;
        int numberOfRowsRequiredToShowCurrentPage = 1 + (this.currentPage - 1) * this.rowsPerPage;
        GridDataSource dataSource = this.gridModel.getDataSource();
        int availableRowsWithLimit = dataSource.getAvailableRows(numberOfRowsRequiredToFillCurrentPage = this.currentPage * this.rowsPerPage);
        if (numberOfRowsRequiredToShowCurrentPage > availableRowsWithLimit) {
            int maxPages;
            this.currentPage = maxPages = (availableRowsWithLimit - 1) / this.rowsPerPage + 1;
        }
        this.startRow = (this.currentPage - 1) * this.rowsPerPage;
        this.endRow = Math.min(availableRowsWithLimit - 1, this.startRow + this.rowsPerPage - 1);
        this.dataRowIndex = this.startRow;
        boolean recordingStateInsideForm = !this.volatileState && this.formSupport != null;
        this.recordStateByIndex = recordingStateInsideForm && this.encoder == null;
        this.recordStateByEncoder = recordingStateInsideForm && this.encoder != null;
    }

    void setupForRow(int rowIndex) {
        this.row = this.gridModel.getDataSource().getRowValue(rowIndex);
    }

    void setupForRowWithClientValue(String clientValue) {
        this.row = this.encoder.toValue(clientValue);
        if (this.row == null) {
            throw new IllegalArgumentException(String.format("%s returned null for client value '%s'.", this.encoder, clientValue));
        }
    }

    boolean beginRender() {
        this.setupForRow(this.dataRowIndex);
        this.rowIndex = this.dataRowIndex - this.startRow;
        if (this.row != null) {
            if (this.recordStateByIndex) {
                this.formSupport.store(this, new SetupForRowByIndex(this.dataRowIndex));
            }
            if (this.recordStateByEncoder) {
                String key = this.encoder.toClient(this.row);
                this.formSupport.store(this, new SetupForRowWithClientValue(key));
            }
        }
        return this.row != null;
    }

    boolean afterRender() {
        ++this.dataRowIndex;
        return this.row == null || this.dataRowIndex > this.endRow;
    }

    public List<String> getPropertyNames() {
        return this.gridModel.getDataModel().getPropertyNames();
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
        this.columnModel = this.gridModel.getDataModel().get(propertyName);
    }

    static class SetupForRowWithClientValue
    implements ComponentAction<GridRows> {
        private final String clientValue;

        SetupForRowWithClientValue(String clientValue) {
            this.clientValue = clientValue;
        }

        @Override
        public void execute(GridRows component) {
            component.setupForRowWithClientValue(this.clientValue);
        }

        public String toString() {
            return String.format("GridRows.SetupForRowWithClientValue[%s]", this.clientValue);
        }
    }

    static class SetupForRowByIndex
    implements ComponentAction<GridRows> {
        private static final long serialVersionUID = -3216282071752371975L;
        private final int rowIndex;

        public SetupForRowByIndex(int rowIndex) {
            this.rowIndex = rowIndex;
        }

        @Override
        public void execute(GridRows component) {
            component.setupForRow(this.rowIndex);
        }

        public String toString() {
            return String.format("GridRows.SetupForRowByIndex[%d]", this.rowIndex);
        }
    }
}

