/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.services.javascript;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.tapestry5.commons.Resource;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.func.Mapper;
import org.apache.tapestry5.func.Predicate;
import org.apache.tapestry5.internal.util.VirtualResource;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.javascript.JavaScriptModuleConfiguration;

public class AMDWrapper {
    private final Resource resource;
    private final Map<String, String> requireConfig = new LinkedHashMap<String, String>();
    private String returnExpression;
    private static final Mapper<Map.Entry<String, String>, String> GET_KEY = new Mapper<Map.Entry<String, String>, String>(){

        public String map(Map.Entry<String, String> element) {
            return element.getKey();
        }
    };
    private static final Predicate<Map.Entry<String, String>> VALUE_IS_NULL = new Predicate<Map.Entry<String, String>>(){

        public boolean accept(Map.Entry<String, String> element) {
            return element.getValue() == null;
        }
    };
    private static final Mapper<String, String> QUOTE = new Mapper<String, String>(){

        public String map(String element) {
            StringBuilder sb = new StringBuilder(element.length() + 2);
            sb.append('\"');
            sb.append(element);
            sb.append('\"');
            return sb.toString();
        }
    };

    public AMDWrapper(Resource resource) {
        this.resource = resource;
    }

    public AMDWrapper require(String moduleName, String parameterName) {
        this.requireConfig.put(moduleName, parameterName);
        return this;
    }

    public AMDWrapper require(String moduleName) {
        this.requireConfig.put(moduleName, null);
        return this;
    }

    public AMDWrapper setReturnExpression(String returnExpression) {
        this.returnExpression = returnExpression;
        return this;
    }

    public JavaScriptModuleConfiguration asJavaScriptModuleConfiguration() {
        return new JavaScriptModuleConfiguration(this.transformResource());
    }

    private Resource transformResource() {
        return new AMDModuleWrapperResource(this.resource, this.requireConfig, this.returnExpression);
    }

    private static final class AMDModuleWrapperResource
    extends VirtualResource {
        private final Resource resource;
        private final Map<String, String> requireConfig;
        private final String returnExpression;

        public AMDModuleWrapperResource(Resource resource, Map<String, String> requireConfig, String returnExpression) {
            this.resource = resource;
            this.requireConfig = requireConfig;
            this.returnExpression = returnExpression;
        }

        public InputStream openStream() throws IOException {
            StringBuilder sb = new StringBuilder();
            Flow requiredModulesToNames = F.flow(this.requireConfig.entrySet());
            Flow requiredModulesToNamesNamedFirst = ((Flow)requiredModulesToNames.remove(VALUE_IS_NULL)).concat((Flow)requiredModulesToNames.filter(VALUE_IS_NULL));
            sb.append("define([");
            sb.append(InternalUtils.join((List)requiredModulesToNamesNamedFirst.map(GET_KEY).map(QUOTE).toList()));
            sb.append("], function(");
            sb.append(InternalUtils.join((List)((Flow)F.flow(this.requireConfig.values()).filter(F.notNull())).toList()));
            sb.append("){\n");
            InputStream leaderStream = AMDModuleWrapperResource.toInputStream(sb);
            sb.setLength(0);
            if (this.returnExpression != null) {
                sb.append("\nreturn ");
                sb.append(this.returnExpression);
                sb.append(';');
            }
            sb.append("\n});");
            InputStream trailerStream = AMDModuleWrapperResource.toInputStream(sb);
            Vector<InputStream> v = new Vector<InputStream>(3);
            v.add(leaderStream);
            v.add(this.resource.openStream());
            v.add(trailerStream);
            return new SequenceInputStream(v.elements());
        }

        @Override
        public String getFile() {
            return "generated-module-for-" + this.resource.getFile();
        }

        @Override
        public URL toURL() {
            return null;
        }

        public String toString() {
            return "AMD module wrapper for " + this.resource.toString();
        }

        private static InputStream toInputStream(StringBuilder sb) {
            return new ByteArrayInputStream(sb.toString().getBytes(UTF8));
        }
    }
}

