/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.examples;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.tez.client.TezClient;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.DataSinkDescriptor;
import org.apache.tez.dag.api.DataSourceDescriptor;
import org.apache.tez.dag.api.Edge;
import org.apache.tez.dag.api.EdgeManagerPluginDescriptor;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.InputInitializerDescriptor;
import org.apache.tez.dag.api.OutputCommitterDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.VertexManagerPluginDescriptor;
import org.apache.tez.dag.api.client.VertexStatus;
import org.apache.tez.examples.TezExampleBase;
import org.apache.tez.mapreduce.processor.SimpleMRProcessor;
import org.apache.tez.runtime.api.AbstractLogicalInput;
import org.apache.tez.runtime.api.AbstractLogicalOutput;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.api.InputInitializer;
import org.apache.tez.runtime.api.InputInitializerContext;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.OutputCommitter;
import org.apache.tez.runtime.api.OutputCommitterContext;
import org.apache.tez.runtime.api.OutputContext;
import org.apache.tez.runtime.api.ProcessorContext;
import org.apache.tez.runtime.api.Reader;
import org.apache.tez.runtime.api.Writer;
import org.apache.tez.runtime.api.events.InputConfigureVertexTasksEvent;
import org.apache.tez.runtime.api.events.InputDataInformationEvent;
import org.apache.tez.runtime.api.events.InputInitializerEvent;
import org.apache.tez.runtime.library.api.KeyValueReader;
import org.apache.tez.runtime.library.api.KeyValueWriter;
import org.apache.tez.runtime.library.cartesianproduct.CartesianProductConfig;
import org.apache.tez.runtime.library.cartesianproduct.CartesianProductEdgeManager;
import org.apache.tez.runtime.library.cartesianproduct.CartesianProductVertexManager;
import org.apache.tez.runtime.library.conf.UnorderedPartitionedKVEdgeConfig;
import org.apache.tez.runtime.library.partitioner.RoundRobinPartitioner;
import org.apache.tez.runtime.library.processor.SimpleProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CartesianProduct
extends TezExampleBase {
    private static final int srcParallelism = 1;
    private static final int numRecordPerSrc = 10;
    private static final String INPUT = "Input1";
    private static final String OUTPUT = "Output";
    private static final String VERTEX1 = "Vertex1";
    private static final String VERTEX2 = "Vertex2";
    private static final String VERTEX3 = "Vertex3";
    private static final Logger LOG = LoggerFactory.getLogger(CartesianProduct.class);
    private static final String[] sourceVertices = new String[]{"Vertex1", "Vertex2"};

    private DAG createDAG(TezConfiguration tezConf) throws IOException {
        InputDescriptor inputDescriptor = InputDescriptor.create((String)FakeInput.class.getName());
        InputInitializerDescriptor inputInitializerDescriptor = InputInitializerDescriptor.create((String)FakeInputInitializer.class.getName());
        DataSourceDescriptor dataSourceDescriptor = DataSourceDescriptor.create((InputDescriptor)inputDescriptor, (InputInitializerDescriptor)inputInitializerDescriptor, null);
        Vertex v1 = Vertex.create((String)VERTEX1, (ProcessorDescriptor)ProcessorDescriptor.create((String)TokenProcessor.class.getName()));
        v1.addDataSource(INPUT, dataSourceDescriptor);
        Vertex v2 = Vertex.create((String)VERTEX2, (ProcessorDescriptor)ProcessorDescriptor.create((String)TokenProcessor.class.getName()));
        v2.addDataSource(INPUT, dataSourceDescriptor);
        OutputDescriptor outputDescriptor = OutputDescriptor.create((String)FakeOutput.class.getName());
        OutputCommitterDescriptor outputCommitterDescriptor = OutputCommitterDescriptor.create((String)FakeOutputCommitter.class.getName());
        DataSinkDescriptor dataSinkDescriptor = DataSinkDescriptor.create((OutputDescriptor)outputDescriptor, (OutputCommitterDescriptor)outputCommitterDescriptor, null);
        CartesianProductConfig cartesianProductConfig = new CartesianProductConfig(Arrays.asList(sourceVertices));
        UserPayload userPayload = cartesianProductConfig.toUserPayload(tezConf);
        Vertex v3 = Vertex.create((String)VERTEX3, (ProcessorDescriptor)ProcessorDescriptor.create((String)JoinProcessor.class.getName()));
        v3.addDataSink(OUTPUT, dataSinkDescriptor);
        v3.setVertexManagerPlugin((VertexManagerPluginDescriptor)VertexManagerPluginDescriptor.create((String)CartesianProductVertexManager.class.getName()).setUserPayload(userPayload));
        EdgeManagerPluginDescriptor edgeManagerDescriptor = EdgeManagerPluginDescriptor.create((String)CartesianProductEdgeManager.class.getName());
        edgeManagerDescriptor.setUserPayload(userPayload);
        UnorderedPartitionedKVEdgeConfig edgeConf = UnorderedPartitionedKVEdgeConfig.newBuilder((String)Text.class.getName(), (String)IntWritable.class.getName(), (String)RoundRobinPartitioner.class.getName()).build();
        EdgeProperty edgeProperty = edgeConf.createDefaultCustomEdgeProperty(edgeManagerDescriptor);
        return DAG.create((String)"CrossProduct").addVertex(v1).addVertex(v2).addVertex(v3).addEdge(Edge.create((Vertex)v1, (Vertex)v3, (EdgeProperty)edgeProperty)).addEdge(Edge.create((Vertex)v2, (Vertex)v3, (EdgeProperty)edgeProperty));
    }

    protected void printUsage() {
    }

    protected int validateArgs(String[] otherArgs) {
        return 0;
    }

    protected int runJob(String[] args, TezConfiguration tezConf, TezClient tezClient) throws Exception {
        DAG dag = this.createDAG(tezConf);
        return this.runDag(dag, this.isCountersLog(), LOG);
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new CartesianProduct(), (String[])args);
        System.exit(res);
    }

    public static class FakeOutput
    extends AbstractLogicalOutput {
        public FakeOutput(OutputContext outputContext, int numPhysicalOutputs) {
            super(outputContext, numPhysicalOutputs);
        }

        public List<Event> initialize() throws Exception {
            this.getContext().requestInitialMemory(0L, null);
            return null;
        }

        public void handleEvents(List<Event> outputEvents) {
        }

        public List<Event> close() throws Exception {
            return null;
        }

        public void start() throws Exception {
        }

        public Writer getWriter() throws Exception {
            return new KeyValueWriter(){

                public void write(Object key, Object value) throws IOException {
                    System.out.println(key + " XXX " + value);
                }
            };
        }
    }

    public static class FakeOutputCommitter
    extends OutputCommitter {
        public FakeOutputCommitter(OutputCommitterContext committerContext) {
            super(committerContext);
        }

        public void initialize() throws Exception {
        }

        public void setupOutput() throws Exception {
        }

        public void commitOutput() throws Exception {
        }

        public void abortOutput(VertexStatus.State finalState) throws Exception {
        }
    }

    public static class FakeInput
    extends AbstractLogicalInput {
        public FakeInput(InputContext inputContext, int numPhysicalInputs) {
            super(inputContext, numPhysicalInputs);
        }

        public List<Event> initialize() throws Exception {
            this.getContext().requestInitialMemory(0L, null);
            this.getContext().inputIsReady();
            return null;
        }

        public void handleEvents(List<Event> inputEvents) throws Exception {
        }

        public List<Event> close() throws Exception {
            return null;
        }

        public void start() throws Exception {
        }

        public Reader getReader() throws Exception {
            return new KeyValueReader(){
                String[] keys = new String[10];
                int i = -1;

                public boolean next() throws IOException {
                    if (this.i == -1) {
                        for (int j = 0; j < 10; ++j) {
                            this.keys[j] = "" + j;
                        }
                    }
                    ++this.i;
                    return this.i < this.keys.length;
                }

                public Object getCurrentKey() throws IOException {
                    return this.keys[this.i];
                }

                public Object getCurrentValue() throws IOException {
                    return this.keys[this.i];
                }
            };
        }
    }

    public static class FakeInputInitializer
    extends InputInitializer {
        public FakeInputInitializer(InputInitializerContext initializerContext) {
            super(initializerContext);
        }

        public List<Event> initialize() throws Exception {
            ArrayList<Event> list = new ArrayList<Event>();
            list.add((Event)InputConfigureVertexTasksEvent.create((int)1, null, null));
            for (int i = 0; i < 1; ++i) {
                list.add((Event)InputDataInformationEvent.createWithObjectPayload((int)i, null));
            }
            return list;
        }

        public void handleInputInitializerEvent(List<InputInitializerEvent> events) throws Exception {
        }
    }

    public static class JoinProcessor
    extends SimpleMRProcessor {
        public JoinProcessor(ProcessorContext context) {
            super(context);
        }

        public void run() throws Exception {
            Text key;
            KeyValueWriter kvWriter = (KeyValueWriter)((LogicalOutput)this.getOutputs().get(CartesianProduct.OUTPUT)).getWriter();
            KeyValueReader kvReader1 = (KeyValueReader)((LogicalInput)this.getInputs().get(CartesianProduct.VERTEX1)).getReader();
            KeyValueReader kvReader2 = (KeyValueReader)((LogicalInput)this.getInputs().get(CartesianProduct.VERTEX2)).getReader();
            HashSet<Text> leftSet = new HashSet<Text>();
            HashSet<Text> rightSet = new HashSet<Text>();
            while (kvReader1.next()) {
                key = (Text)kvReader1.getCurrentKey();
                leftSet.add(new Text(key));
            }
            while (kvReader2.next()) {
                key = (Text)kvReader2.getCurrentKey();
                rightSet.add(new Text(key));
            }
            for (Object e : leftSet) {
                for (Object e2 : rightSet) {
                    kvWriter.write(e, e2);
                }
            }
        }
    }

    public static class TokenProcessor
    extends SimpleProcessor {
        public TokenProcessor(ProcessorContext context) {
            super(context);
        }

        public void run() throws Exception {
            Preconditions.checkArgument((this.getInputs().size() == 1 ? 1 : 0) != 0);
            Preconditions.checkArgument((this.getOutputs().size() == 1 ? 1 : 0) != 0);
            KeyValueReader kvReader = (KeyValueReader)((LogicalInput)this.getInputs().get(CartesianProduct.INPUT)).getReader();
            KeyValueWriter kvWriter = (KeyValueWriter)((LogicalOutput)this.getOutputs().get(CartesianProduct.VERTEX3)).getWriter();
            while (kvReader.next()) {
                Object key = kvReader.getCurrentKey();
                Object value = kvReader.getCurrentValue();
                kvWriter.write((Object)new Text((String)key), (Object)new IntWritable(1));
            }
        }
    }
}

