/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.MapConfiguration;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;

public class OptionsStrategy
extends AbstractTraversalStrategy<TraversalStrategy.DecorationStrategy>
implements TraversalStrategy.DecorationStrategy {
    public static final OptionsStrategy EMPTY = OptionsStrategy.build().create();
    private final Map<String, Object> options;

    private OptionsStrategy(Builder builder) {
        this.options = builder.options;
    }

    public Map<String, Object> getOptions() {
        return Collections.unmodifiableMap(this.options);
    }

    @Override
    public Configuration getConfiguration() {
        return new MapConfiguration(this.options);
    }

    @Override
    public void apply(Traversal.Admin<?, ?> traversal) {
    }

    public static OptionsStrategy create(Configuration configuration) {
        Builder builder = OptionsStrategy.build();
        configuration.getKeys().forEachRemaining(k -> builder.with((String)k, configuration.getProperty(k)));
        return builder.create();
    }

    public static Builder build() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, Object> options = new HashMap<String, Object>();

        public Builder with(String key) {
            return this.with(key, true);
        }

        public Builder with(String key, Object value) {
            this.options.put(key, value);
            return this;
        }

        public OptionsStrategy create() {
            return new OptionsStrategy(this);
        }
    }
}

