/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.branch;

import java.util.Collections;
import org.apache.tinkerpop.gremlin.process.traversal.Pick;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.TraverserGenerator;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.ConstantTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.BranchStep;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public class UnionStep<S, E>
extends BranchStep<S, E, Pick> {
    private final boolean isStart;
    protected boolean first = true;
    static final Object UNION_STARTER = new Object();

    public UnionStep(Traversal.Admin traversal, boolean isStart, Traversal.Admin<?, E> ... unionTraversals) {
        super(traversal);
        this.isStart = isStart;
        this.setBranchTraversal(new ConstantTraversal(Pick.any));
        for (Traversal.Admin<?, E> union : unionTraversals) {
            this.addChildOption(Pick.any, union);
        }
    }

    public UnionStep(Traversal.Admin traversal, Traversal.Admin<?, E> ... unionTraversals) {
        this(traversal, false, unionTraversals);
    }

    public boolean isStart() {
        return this.isStart;
    }

    @Override
    protected Traverser.Admin<E> processNextStart() {
        if (this.isStart && this.first) {
            this.first = false;
            TraverserGenerator generator = this.getTraversal().getTraverserGenerator();
            Traverser.Admin<Object> traverser = generator.generate(UNION_STARTER, this, 1L);
            traverser.dropPath();
            this.addStart(traverser);
        }
        Traverser.Admin t = super.processNextStart();
        if (this.isStart) {
            while (t != null && t.get() == UNION_STARTER) {
                t = super.processNextStart();
            }
        }
        return t;
    }

    @Override
    public void addChildOption(Pick pickToken, Traversal.Admin<S, E> traversalOption) {
        if (Pick.any != pickToken) {
            throw new IllegalArgumentException("Union step only supports the any token: " + pickToken);
        }
        super.addChildOption(pickToken, traversalOption);
    }

    @Override
    public void reset() {
        super.reset();
        this.first = true;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.traversalPickOptions.getOrDefault((Object)Pick.any, Collections.emptyList()));
    }
}

