package org.apache.stratum.lifecycle;

/*
 * Copyright 2001-2005 The Apache Software Foundation or its licensors,
 * as applicable.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * The Startable interface is used when components need to be "running" to be active. It provides a method through which components
 * can be "started" and "stopped" without requiring a thread. Note that these methods should start the component but return
 * imediately.
 *
 * @author <a href="mailto:donaldp@apache.org">Peter Donald</a>
 * @author <a href="mailto:bloritsch@apache.org">Berin Loritsch</a>
 */
public interface Startable
{
    /**
     * Starts the component.
     *
     * @exception Exception if Component can not be started
     */
    void start()
            throws Exception;

    /**
     * Stops the component.
     *
     * @exception Exception if the Component can not be Stopped.
     */
    void stop()
            throws Exception;
}
