/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.rule;

import java.util.List;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleElementContainer;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.rule.RutaLiteralMatcher;
import org.apache.uima.ruta.rule.RutaRule;
import org.apache.uima.ruta.rule.RutaRuleElement;
import org.apache.uima.ruta.visitor.InferenceCrowd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleElementCaretaker
implements RuleElementContainer {
    private final RuleElementContainer container;

    public RuleElementCaretaker(RuleElementContainer container) {
        this.container = container;
    }

    public RuleElement getElementAfter(RuleElement element) {
        int indexOf = this.container.getRuleElements().indexOf(element);
        if (indexOf < this.container.getRuleElements().size() - 1) {
            RuleElement ruleElement = this.container.getRuleElements().get(indexOf + 1);
            return ruleElement;
        }
        return null;
    }

    public RuleElement getElementBefore(RuleElement element) {
        int indexOf = this.container.getRuleElements().indexOf(element);
        if (indexOf > 0) {
            RuleElement ruleElement = this.container.getRuleElements().get(indexOf - 1);
            return ruleElement;
        }
        return null;
    }

    @Override
    public List<RuleElement> getRuleElements() {
        return this.container.getRuleElements();
    }

    @Override
    public RuleElement getAnchoringRuleElement(RutaStream stream) {
        List<RuleElement> ruleElements = this.container.getRuleElements();
        if (ruleElements.size() == 1 || this.containsLiteralMatcher(ruleElements)) {
            return ruleElements.get(0);
        }
        if (stream.isDynamicAnchoring()) {
            int min = Integer.MAX_VALUE;
            RuleElement minElement = null;
            int i = 1;
            for (RuleElement each : ruleElements) {
                int estimate = each.estimateAnchors(stream);
                double factor = stream.getIndexPenalty();
                if ((estimate = (int)(Math.log(estimate) * ((double)i * factor))) < min) {
                    min = estimate;
                    minElement = each;
                }
                ++i;
            }
            return minElement;
        }
        return ruleElements.get(0);
    }

    private boolean containsLiteralMatcher(List<RuleElement> ruleElements) {
        for (RuleElement each : ruleElements) {
            RutaRuleElement re;
            if (!(each instanceof RutaRuleElement) || !((re = (RutaRuleElement)each).getMatcher() instanceof RutaLiteralMatcher)) continue;
            return true;
        }
        return false;
    }

    @Override
    public RuleElement getFirstElement() {
        List<RuleElement> ruleElements = this.container.getRuleElements();
        return ruleElements.get(0);
    }

    @Override
    public RuleElement getLastElement() {
        List<RuleElement> ruleElements = this.container.getRuleElements();
        return ruleElements.get(ruleElements.size() - 1);
    }

    @Override
    public void applyRuleElements(RuleMatch ruleMatch, RutaStream stream, InferenceCrowd crowd) {
        for (RuleElement eachElement : this.getRuleElements()) {
            eachElement.apply(ruleMatch, stream, crowd);
        }
    }

    @Override
    public RutaRule getRule() {
        return this.container.getRule();
    }

    @Override
    public RuleElement getNextElement(boolean after, RuleElement ruleElement) {
        if (after) {
            return this.getElementAfter(ruleElement);
        }
        return this.getElementBefore(ruleElement);
    }
}

